/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator;

import io.crate.data.Input;
import io.crate.expression.RegexpFlags;
import io.crate.expression.operator.Operator;
import io.crate.expression.operator.OperatorModule;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.UndefinedType;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.apache.lucene.util.automaton.RegExp;

public class RegexpMatchOperator
extends Operator<String> {
    public static final String NAME = "op_~";
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(OperatorModule module) {
        List<UndefinedType> supportedArgumentTypes = List.of(DataTypes.STRING, DataTypes.UNDEFINED);
        for (DataType dataType : supportedArgumentTypes) {
            for (DataType dataType2 : supportedArgumentTypes) {
                module.register(Signature.scalar(NAME, dataType.getTypeSignature(), dataType2.getTypeSignature(), Operator.RETURN_TYPE.getTypeSignature()).withForbiddenCoercion(), RegexpMatchOperator::new);
            }
        }
    }

    public RegexpMatchOperator(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String>[] args) {
        assert (args.length == 2) : "invalid number of arguments";
        String source = args[0].value();
        if (source == null) {
            return null;
        }
        String pattern = args[1].value();
        if (pattern == null) {
            return null;
        }
        if (RegexpFlags.isPcrePattern(pattern)) {
            return source.matches(pattern);
        }
        RegExp regexp = new RegExp(pattern);
        ByteRunAutomaton regexpRunAutomaton = new ByteRunAutomaton(regexp.toAutomaton());
        byte[] bytes = source.getBytes(StandardCharsets.UTF_8);
        return regexpRunAutomaton.run(bytes, 0, bytes.length);
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }
}

