/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator;

import io.crate.data.Input;
import io.crate.expression.operator.Operator;
import io.crate.expression.operator.OperatorModule;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.UndefinedType;
import java.util.List;
import java.util.regex.Pattern;

public class RegexpMatchCaseInsensitiveOperator
extends Operator<String> {
    public static final String NAME = "op_~*";
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(OperatorModule module) {
        List<UndefinedType> supportedArgumentTypes = List.of(DataTypes.STRING, DataTypes.UNDEFINED);
        for (DataType dataType : supportedArgumentTypes) {
            for (DataType dataType2 : supportedArgumentTypes) {
                module.register(Signature.scalar(NAME, dataType.getTypeSignature(), dataType2.getTypeSignature(), Operator.RETURN_TYPE.getTypeSignature()).withForbiddenCoercion(), RegexpMatchCaseInsensitiveOperator::new);
            }
        }
    }

    public RegexpMatchCaseInsensitiveOperator(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String>[] args) {
        assert (args.length == 2) : "invalid number of arguments";
        String source = args[0].value();
        if (source == null) {
            return null;
        }
        String pattern = args[1].value();
        if (pattern == null) {
            return null;
        }
        Pattern p = Pattern.compile(pattern, 66);
        return p.matcher(source).matches();
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }
}

