/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator;

import io.crate.data.Input;
import io.crate.expression.operator.Operator;
import io.crate.expression.operator.OperatorModule;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;

public class OrOperator
extends Operator<Boolean> {
    public static final String NAME = "op_or";
    public static final Signature SIGNATURE = Signature.scalar("op_or", DataTypes.BOOLEAN.getTypeSignature(), DataTypes.BOOLEAN.getTypeSignature(), DataTypes.BOOLEAN.getTypeSignature());
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(OperatorModule module) {
        module.register(SIGNATURE, OrOperator::new);
    }

    public OrOperator(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Symbol normalizeSymbol(Function function, TransactionContext txnCtx, NodeContext nodeCtx) {
        assert (function != null) : "function must not be null";
        assert (function.arguments().size() == 2) : "number of args must be 2";
        Symbol left = function.arguments().get(0);
        Symbol right = function.arguments().get(1);
        if (left.symbolType().isValueSymbol() && right.symbolType().isValueSymbol()) {
            return Literal.of((Boolean)this.evaluate(txnCtx, nodeCtx, new Input[]{(Input)((Object)left), (Input)((Object)right)}));
        }
        if (left instanceof Input) {
            Object value = ((Input)((Object)left)).value();
            if (value == null) {
                return function;
            }
            assert (value instanceof Boolean) : "value must be Boolean";
            if (((Boolean)value).booleanValue()) {
                return Literal.of(true);
            }
            return right;
        }
        if (right instanceof Input) {
            Object value = ((Input)((Object)right)).value();
            if (value == null) {
                return function;
            }
            assert (value instanceof Boolean) : "value must be Boolean";
            if (((Boolean)value).booleanValue()) {
                return Literal.of(true);
            }
            return left;
        }
        return function;
    }

    @Override
    public Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Boolean> ... args) {
        assert (args != null) : "args must not be null";
        assert (args.length == 2) : "number of args must be 2";
        assert (args[0] != null && args[1] != null) : "1st and 2nd argument must not be null";
        Boolean left = args[0].value();
        Boolean right = args[1].value();
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right != false ? Boolean.valueOf(true) : null;
        }
        if (right == null) {
            return left != false ? Boolean.valueOf(true) : null;
        }
        return left != false || right != false;
    }
}

