/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator;

import io.crate.expression.operator.LikeOperator;
import io.crate.expression.operator.Operator;
import io.crate.expression.operator.OperatorModule;
import io.crate.expression.operator.TriPredicate;
import io.crate.expression.operator.any.AnyLikeOperator;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.regex.Pattern;

public class LikeOperators {
    public static final String OP_LIKE = "op_like";
    public static final String OP_ILIKE = "op_ilike";
    public static final String ANY_LIKE = "any_like";
    public static final String ANY_ILIKE = "any_ilike";
    public static final String ANY_NOT_LIKE = "any_not_like";
    public static final String ANY_NOT_ILIKE = "any_not_ilike";
    public static final char DEFAULT_ESCAPE = '\\';
    private static final int CASE_SENSITIVE = 32;
    private static final int CASE_INSENSITIVE = 34;

    public static String arrayOperatorName(boolean ignoreCase) {
        return ignoreCase ? OP_ILIKE : OP_LIKE;
    }

    public static String arrayOperatorName(boolean negate, boolean ignoreCase) {
        String name = negate ? (ignoreCase ? ANY_NOT_ILIKE : ANY_NOT_LIKE) : (ignoreCase ? ANY_ILIKE : ANY_LIKE);
        return name;
    }

    public static void register(OperatorModule module) {
        module.register(Signature.scalar(OP_LIKE, DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), Operator.RETURN_TYPE.getTypeSignature()), (signature, boundSignature) -> new LikeOperator((Signature)signature, (Signature)boundSignature, LikeOperators::matches, 32));
        module.register(Signature.scalar(OP_ILIKE, DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), Operator.RETURN_TYPE.getTypeSignature()), (signature, boundSignature) -> new LikeOperator((Signature)signature, (Signature)boundSignature, LikeOperators::matches, 34));
        module.register(Signature.scalar(ANY_LIKE, TypeSignature.parseTypeSignature("E"), TypeSignature.parseTypeSignature("array(E)"), Operator.RETURN_TYPE.getTypeSignature()).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E")), (signature, boundSignature) -> new AnyLikeOperator((Signature)signature, (Signature)boundSignature, LikeOperators::matches, 32));
        module.register(Signature.scalar(ANY_NOT_LIKE, TypeSignature.parseTypeSignature("E"), TypeSignature.parseTypeSignature("array(E)"), Operator.RETURN_TYPE.getTypeSignature()).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E")), (signature, boundSignature) -> new AnyLikeOperator((Signature)signature, (Signature)boundSignature, TriPredicate.negate(LikeOperators::matches), 32));
        module.register(Signature.scalar(ANY_ILIKE, TypeSignature.parseTypeSignature("E"), TypeSignature.parseTypeSignature("array(E)"), Operator.RETURN_TYPE.getTypeSignature()).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E")), (signature, boundSignature) -> new AnyLikeOperator((Signature)signature, (Signature)boundSignature, LikeOperators::matches, 34));
        module.register(Signature.scalar(ANY_NOT_ILIKE, TypeSignature.parseTypeSignature("E"), TypeSignature.parseTypeSignature("array(E)"), Operator.RETURN_TYPE.getTypeSignature()).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E")), (signature, boundSignature) -> new AnyLikeOperator((Signature)signature, (Signature)boundSignature, TriPredicate.negate(LikeOperators::matches), 34));
    }

    static final Pattern makePattern(String pattern, int flags) {
        return Pattern.compile(LikeOperators.patternToRegex(pattern, '\\', true), flags);
    }

    static boolean matches(String expression, String pattern, int patternMatchingFlags) {
        return LikeOperators.makePattern(pattern, patternMatchingFlags).matcher(expression).matches();
    }

    public static String patternToRegex(String patternString) {
        return LikeOperators.patternToRegex(patternString, '\\', true);
    }

    public static String patternToRegex(String patternString, char escapeChar, boolean shouldEscape) {
        StringBuilder regex = new StringBuilder(patternString.length() * 2);
        regex.append('^');
        boolean escaped = false;
        block7: for (char currentChar : patternString.toCharArray()) {
            if (shouldEscape && !escaped && currentChar == escapeChar) {
                escaped = true;
                continue;
            }
            switch (currentChar) {
                case '%': {
                    if (escaped) {
                        regex.append("%");
                    } else {
                        regex.append(".*");
                    }
                    escaped = false;
                    continue block7;
                }
                case '_': {
                    if (escaped) {
                        regex.append("_");
                    } else {
                        regex.append('.');
                    }
                    escaped = false;
                    continue block7;
                }
                default: {
                    switch (currentChar) {
                        case '$': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '+': 
                        case '.': 
                        case '[': 
                        case '\\': 
                        case ']': 
                        case '^': 
                        case '|': {
                            regex.append('\\');
                            break;
                        }
                    }
                    regex.append(currentChar);
                    escaped = false;
                }
            }
        }
        regex.append('$');
        return regex.toString();
    }
}

