/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator;

import io.crate.data.Input;
import io.crate.expression.operator.LikeOperators;
import io.crate.expression.operator.Operator;
import io.crate.expression.operator.TriPredicate;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import java.util.List;
import java.util.regex.Pattern;

public class LikeOperator
extends Operator<String> {
    private final Signature signature;
    private final Signature boundSignature;
    private final TriPredicate<String, String, Integer> matcher;
    private final int patternMatchingFlags;

    public LikeOperator(Signature signature, Signature boundSignature, TriPredicate<String, String, Integer> matcher, int patternMatchingFlags) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.matcher = matcher;
        this.patternMatchingFlags = patternMatchingFlags;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Scalar<Boolean, String> compile(List<Symbol> arguments) {
        Symbol pattern = arguments.get(1);
        if (pattern instanceof Input) {
            Object value = ((Input)((Object)pattern)).value();
            if (value == null) {
                return this;
            }
            return new CompiledLike(this.signature, this.boundSignature, (String)value, this.patternMatchingFlags);
        }
        return super.compile(arguments);
    }

    @Override
    public Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String> ... args) {
        assert (args != null) : "args must not be null";
        assert (args.length == 2) : "number of args must be 2";
        String expression = args[0].value();
        String pattern = args[1].value();
        if (expression == null || pattern == null) {
            return null;
        }
        return this.matcher.test(expression, pattern, this.patternMatchingFlags);
    }

    private static class CompiledLike
    extends Scalar<Boolean, String> {
        private final Signature signature;
        private final Signature boundSignature;
        private final Pattern pattern;

        CompiledLike(Signature signature, Signature boundSignature, String pattern, int patternMatchingFlags) {
            this.signature = signature;
            this.boundSignature = boundSignature;
            this.pattern = LikeOperators.makePattern(pattern, patternMatchingFlags);
        }

        @Override
        public Signature signature() {
            return this.signature;
        }

        @Override
        public Signature boundSignature() {
            return this.boundSignature;
        }

        @Override
        @SafeVarargs
        public final Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String> ... args) {
            String value = args[0].value();
            if (value == null) {
                return null;
            }
            return this.pattern.matcher(value).matches();
        }
    }
}

