/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator;

import io.crate.common.collections.MapComparator;
import io.crate.data.Input;
import io.crate.expression.operator.Operator;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntPredicate;

public final class CmpOperator
extends Operator<Object> {
    private final Signature signature;
    private final Signature boundSignature;
    private final IntPredicate isMatch;

    public CmpOperator(Signature signature, Signature boundSignature, IntPredicate cmpResultIsMatch) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.isMatch = cmpResultIsMatch;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        assert (args != null) : "args must not be null";
        assert (args.length == 2) : "number of args must be 2";
        assert (args[0] != null && args[1] != null) : "1st and 2nd argument must not be null";
        Object left = args[0].value();
        Object right = args[1].value();
        if (left == null || right == null) {
            return null;
        }
        assert (left.getClass().equals(right.getClass())) : "left and right must have the same type for comparison";
        if (left instanceof Comparable) {
            return this.isMatch.test(((Comparable)left).compareTo(right));
        }
        if (left instanceof Map) {
            return this.isMatch.test(Objects.compare((Map)left, (Map)right, MapComparator.getInstance()));
        }
        return null;
    }
}

