/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator;

import io.crate.data.Input;
import io.crate.expression.operator.Operator;
import io.crate.expression.operator.OperatorModule;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AndOperator
extends Operator<Boolean> {
    public static final String NAME = "op_and";
    public static final Signature SIGNATURE = Signature.scalar("op_and", DataTypes.BOOLEAN.getTypeSignature(), DataTypes.BOOLEAN.getTypeSignature(), DataTypes.BOOLEAN.getTypeSignature());
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(OperatorModule module) {
        module.register(SIGNATURE, AndOperator::new);
    }

    public AndOperator(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Symbol normalizeSymbol(Function function, TransactionContext txnCtx, NodeContext nodeCtx) {
        assert (function != null) : "function must not be null";
        assert (function.arguments().size() == 2) : "number of args must be 2";
        Symbol left = function.arguments().get(0);
        Symbol right = function.arguments().get(1);
        if (left instanceof Input && right instanceof Input) {
            return Literal.of((Boolean)this.evaluate(txnCtx, nodeCtx, new Input[]{(Input)((Object)left), (Input)((Object)right)}));
        }
        if (left instanceof Input) {
            Object value = ((Input)((Object)left)).value();
            if (value == null) {
                return function;
            }
            if (((Boolean)value).booleanValue()) {
                return right;
            }
            return Literal.of(false);
        }
        if (right instanceof Input) {
            Object value = ((Input)((Object)right)).value();
            if (value == null) {
                return function;
            }
            if (((Boolean)value).booleanValue()) {
                return left;
            }
            return Literal.of(false);
        }
        return function;
    }

    @Override
    public Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Boolean> ... args) {
        assert (args != null) : "args must not be null";
        assert (args.length == 2) : "number of args must be 2";
        assert (args[0] != null && args[1] != null) : "1st and 2nd arguments must not be null";
        Boolean left = args[0].value();
        Boolean right = args[1].value();
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right == false ? Boolean.valueOf(false) : null;
        }
        if (right == null) {
            return left == false ? Boolean.valueOf(false) : null;
        }
        return left != false && right != false;
    }

    public static Function of(Symbol first, Symbol second) {
        assert (first.valueType().equals(DataTypes.BOOLEAN) || first.valueType().equals(DataTypes.UNDEFINED)) : "first symbol must have BOOLEAN return type to create AND function";
        assert (second.valueType().equals(DataTypes.BOOLEAN) || second.valueType().equals(DataTypes.UNDEFINED)) : "second symbol must have BOOLEAN return type to create AND function";
        return new Function(SIGNATURE, List.of(first, second), Operator.RETURN_TYPE);
    }

    public static Symbol join(Iterable<? extends Symbol> symbols) {
        return AndOperator.join(symbols.iterator());
    }

    public static Symbol join(Iterator<? extends Symbol> symbols) {
        if (!symbols.hasNext()) {
            return Literal.BOOLEAN_TRUE;
        }
        Symbol first = symbols.next();
        while (symbols.hasNext()) {
            first = new Function(SIGNATURE, List.of(first, symbols.next()), Operator.RETURN_TYPE);
        }
        return first;
    }

    public static List<Symbol> split(Symbol predicate) {
        ArrayList<Symbol> conjunctions = new ArrayList<Symbol>();
        predicate.accept(SplitVisitor.INSTANCE, conjunctions);
        if (conjunctions.isEmpty()) {
            conjunctions.add(predicate);
        }
        return conjunctions;
    }

    static class SplitVisitor
    extends SymbolVisitor<List<Symbol>, Symbol> {
        private static final SplitVisitor INSTANCE = new SplitVisitor();

        SplitVisitor() {
        }

        @Override
        protected Symbol visitSymbol(Symbol symbol, List<Symbol> context) {
            return symbol;
        }

        @Override
        public Symbol visitFunction(Function func, List<Symbol> conjunctions) {
            Signature signature = func.signature();
            assert (signature != null) : "Expecting functions signature not to be null";
            if (signature.equals(SIGNATURE)) {
                for (Symbol argument : func.arguments()) {
                    Symbol result = argument.accept(this, conjunctions);
                    if (result == null) continue;
                    conjunctions.add(result);
                }
                return null;
            }
            return func;
        }
    }
}

