/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator;

import io.crate.data.Input;
import io.crate.expression.operator.Operator;
import io.crate.expression.operator.OperatorModule;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.sql.tree.ComparisonExpression;
import io.crate.types.DataType;
import io.crate.types.TypeSignature;
import java.util.Collection;
import java.util.function.IntPredicate;

public final class AllOperator
extends Operator<Object> {
    public static final String OPERATOR_PREFIX = "_all_";
    private final Signature signature;
    private final Signature boundSignature;
    private final IntPredicate cmp;
    private final DataType leftType;

    public static void register(OperatorModule module) {
        for (Type type : Type.values()) {
            module.register(Signature.scalar(type.fullQualifiedName, TypeSignature.parseTypeSignature("E"), TypeSignature.parseTypeSignature("array(E)"), Operator.RETURN_TYPE.getTypeSignature()).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E")), (signature, boundSignature) -> new AllOperator((Signature)signature, (Signature)boundSignature, type.cmp));
        }
    }

    public AllOperator(Signature signature, Signature boundSignature, IntPredicate cmp) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.cmp = cmp;
        this.leftType = boundSignature.getArgumentDataTypes().get(0);
    }

    @Override
    public Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object>[] args) {
        Object leftValue = args[0].value();
        Collection rightValues = (Collection)args[1].value();
        if (leftValue == null || rightValues == null) {
            return null;
        }
        boolean anyNulls = false;
        int matches = 0;
        for (Object rightValue : rightValues) {
            if (rightValue == null) {
                anyNulls = true;
                ++matches;
                continue;
            }
            if (!this.cmp.test(this.leftType.compare(leftValue, rightValue))) continue;
            ++matches;
        }
        if (matches == rightValues.size()) {
            return anyNulls ? null : Boolean.valueOf(true);
        }
        return false;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    private static enum Type {
        EQ(ComparisonExpression.Type.EQUAL, result -> result == 0),
        NEQ(ComparisonExpression.Type.NOT_EQUAL, result -> result != 0),
        GTE(ComparisonExpression.Type.GREATER_THAN_OR_EQUAL, result -> result >= 0),
        GT(ComparisonExpression.Type.GREATER_THAN, result -> result > 0),
        LTE(ComparisonExpression.Type.LESS_THAN_OR_EQUAL, result -> result <= 0),
        LT(ComparisonExpression.Type.LESS_THAN, result -> result < 0);

        final String fullQualifiedName;
        final IntPredicate cmp;

        private Type(ComparisonExpression.Type type, IntPredicate cmp) {
            this.fullQualifiedName = AllOperator.OPERATOR_PREFIX + type.getValue();
            this.cmp = cmp;
        }
    }
}

