/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.expression.InputCondition;
import io.crate.expression.InputFactory;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.TransactionContext;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class RowFilter
implements Predicate<Row> {
    private final Input<Boolean> filterCondition;
    private final List<CollectExpression<Row, ?>> expressions;

    public static Predicate<Row> create(TransactionContext txnCtx, InputFactory inputFactory, @Nullable Symbol filterSymbol) {
        if (filterSymbol == null) {
            return i -> true;
        }
        return new RowFilter(txnCtx, inputFactory, filterSymbol);
    }

    private RowFilter(TransactionContext txnCtx, InputFactory inputFactory, Symbol filterSymbol) {
        InputFactory.Context<CollectExpression<Row, ?>> ctx = inputFactory.ctxForInputColumns(txnCtx);
        this.filterCondition = ctx.add(filterSymbol);
        this.expressions = ctx.expressions();
    }

    @Override
    public boolean test(@Nullable Row row) {
        int expressionsSize = this.expressions.size();
        for (int i = 0; i < expressionsSize; ++i) {
            CollectExpression<Row, ?> expression = this.expressions.get(i);
            expression.setNextRow(row);
        }
        return InputCondition.matches(this.filterCondition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowFilter rowFilter = (RowFilter)o;
        if (!this.filterCondition.equals(rowFilter.filterCondition)) {
            return false;
        }
        return this.expressions.equals(rowFilter.expressions);
    }

    public int hashCode() {
        int result = this.filterCondition.hashCode();
        result = 31 * result + this.expressions.hashCode();
        return result;
    }
}

