/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression;

import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class RegexpFlags {
    private static final String CHARACTER_CLASSES = "dDsSwW";
    private static final String BOUNDARY_MATCHERS = "bBAGZz";
    private static final String EMBEDDED_FLAGS = "idmsuxU";
    private static final String ESCAPE_SEQUENCES_PATTERN = ".*\\\\[dDsSwWbBAGZz].*";
    private static final String EMBEDDED_FLAGS_PATTERN = "^\\(\\?[idmsuxU]\\).*";
    private static final Pattern PCRE_PATTERN = Pattern.compile(".*\\\\[dDsSwWbBAGZz].*|^\\(\\?[idmsuxU]\\).*");

    public static int parseFlags(@Nullable String flagsString) {
        int flags = 0;
        if (flagsString == null) {
            return flags;
        }
        block10: for (char flag : flagsString.toCharArray()) {
            switch (flag) {
                case 'i': {
                    flags |= 2;
                    continue block10;
                }
                case 'u': {
                    flags |= 0x40;
                    continue block10;
                }
                case 'U': {
                    flags |= 0x100;
                    continue block10;
                }
                case 's': {
                    flags |= 0x20;
                    continue block10;
                }
                case 'm': {
                    flags |= 8;
                    continue block10;
                }
                case 'x': {
                    flags |= 4;
                    continue block10;
                }
                case 'd': {
                    flags |= 1;
                    continue block10;
                }
                case ' ': 
                case 'g': {
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("The regular expression flag is unknown: " + flag);
                }
            }
        }
        return flags;
    }

    public static boolean isGlobal(@Nullable String flags) {
        if (flags == null) {
            return false;
        }
        return flags.indexOf(103) != -1;
    }

    public static boolean isPcrePattern(String pattern) {
        return PCRE_PATTERN.matcher(pattern).matches();
    }

    private RegexpFlags() {
        throw new UnsupportedOperationException("utils class");
    }
}

