/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression;

import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.execution.engine.aggregation.AggregationContext;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.collect.InputCollectExpression;
import io.crate.expression.BaseImplementationSymbolVisitor;
import io.crate.expression.reference.GatheringRefResolver;
import io.crate.expression.reference.ReferenceResolver;
import io.crate.expression.symbol.Aggregation;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.metadata.FunctionImplementation;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.TransactionContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InputFactory {
    private final NodeContext nodeCtx;

    public InputFactory(NodeContext nodeCtx) {
        this.nodeCtx = nodeCtx;
    }

    public <T extends Input<?>> Context<T> ctxForRefs(TransactionContext txnCtx, ReferenceResolver<? extends T> referenceResolver) {
        ArrayList expressions = new ArrayList();
        return new Context(expressions, new RefVisitor<T>(txnCtx, this.nodeCtx, new GatheringRefResolver<T>(expressions::add, referenceResolver)));
    }

    public Context<CollectExpression<Row, ?>> ctxForInputColumns(TransactionContext txnCtx) {
        ArrayList expressions = new ArrayList();
        return new Context(expressions, new InputColumnVisitor(txnCtx, this.nodeCtx, expressions));
    }

    public Context<CollectExpression<Row, ?>> ctxForInputColumns(TransactionContext txnCtx, Iterable<? extends Symbol> symbols) {
        Context<CollectExpression<Row, ?>> context = this.ctxForInputColumns(txnCtx);
        context.add(symbols);
        return context;
    }

    public Context<CollectExpression<Row, ?>> ctxForAggregations(TransactionContext txnCtx) {
        ArrayList expressions = new ArrayList();
        ArrayList<AggregationContext> aggregationContexts = new ArrayList<AggregationContext>();
        return new Context(expressions, aggregationContexts, new AggregationVisitor(txnCtx, this.nodeCtx, expressions, aggregationContexts));
    }

    public static class Context<T extends Input<?>> {
        private final List<Input<?>> topLevelInputs = new ArrayList();
        private final List<T> expressions;
        private final List<AggregationContext> aggregationContexts;
        private final SymbolVisitor<?, Input<?>> visitor;

        private Context(List<T> expressions, List<AggregationContext> aggregationContexts, SymbolVisitor<?, Input<?>> visitor) {
            this.expressions = expressions;
            this.aggregationContexts = aggregationContexts;
            this.visitor = visitor;
        }

        private Context(List<T> expressions, SymbolVisitor<?, Input<?>> visitor) {
            this(expressions, Collections.emptyList(), visitor);
        }

        public List<Input<?>> topLevelInputs() {
            return this.topLevelInputs;
        }

        public List<T> expressions() {
            return this.expressions;
        }

        public void add(Iterable<? extends Symbol> symbols) {
            for (Symbol symbol : symbols) {
                Input<?> input = this.add(symbol);
                if (input == null) continue;
                this.topLevelInputs.add(input);
            }
        }

        public Input<?> add(Symbol symbol) {
            return symbol.accept(this.visitor, null);
        }

        public List<AggregationContext> aggregations() {
            return this.aggregationContexts;
        }
    }

    private static class RefVisitor<T extends Input<?>>
    extends BaseImplementationSymbolVisitor<Void> {
        private final ReferenceResolver<T> referenceResolver;
        private final Map<Reference, T> referenceMap;

        RefVisitor(TransactionContext txnCtx, NodeContext nodeCtx, ReferenceResolver<T> referenceResolver) {
            super(txnCtx, nodeCtx);
            this.referenceResolver = referenceResolver;
            this.referenceMap = new HashMap<Reference, T>();
        }

        @Override
        public Input<?> visitReference(Reference ref, Void context) {
            Input implementation = (Input)this.referenceMap.get(ref);
            if (implementation != null) {
                return implementation;
            }
            implementation = this.referenceResolver.getImplementation(ref);
            if (implementation == null) {
                throw new IllegalArgumentException("Column implementation not found for: " + ref);
            }
            this.referenceMap.put(ref, implementation);
            return implementation;
        }
    }

    private static class InputColumnVisitor
    extends BaseImplementationSymbolVisitor<Void> {
        private final List<CollectExpression<Row, ?>> expressions;
        private final IntObjectMap<InputCollectExpression> inputCollectExpressions = new IntObjectHashMap();

        InputColumnVisitor(TransactionContext txnCtx, NodeContext nodeCtx, List<CollectExpression<Row, ?>> expressions) {
            super(txnCtx, nodeCtx);
            this.expressions = expressions;
        }

        @Override
        public Input<?> visitInputColumn(InputColumn inputColumn, Void context) {
            int index = inputColumn.index();
            InputCollectExpression inputCollectExpression = (InputCollectExpression)this.inputCollectExpressions.get(index);
            if (inputCollectExpression == null) {
                inputCollectExpression = new InputCollectExpression(index);
                this.inputCollectExpressions.put(index, (Object)inputCollectExpression);
                this.expressions.add(inputCollectExpression);
            }
            return inputCollectExpression;
        }
    }

    private static class AggregationVisitor
    extends InputColumnVisitor {
        private final List<AggregationContext> aggregationContexts;

        AggregationVisitor(TransactionContext txnCtx, NodeContext nodeCtx, List<CollectExpression<Row, ?>> expressions, List<AggregationContext> aggregationContexts) {
            super(txnCtx, nodeCtx, expressions);
            this.aggregationContexts = aggregationContexts;
        }

        @Override
        public Input<?> visitAggregation(Aggregation aggregation, Void context) {
            FunctionImplementation impl = this.nodeCtx.functions().getQualified(aggregation, this.txnCtx.sessionSettings().searchPath());
            assert (impl != null) : "Function implementation not found using full qualified lookup";
            Input filter = (Input)aggregation.filter().accept(this, context);
            ArrayList inputs = new ArrayList(aggregation.inputs().size());
            for (Symbol aggInput : aggregation.inputs()) {
                inputs.add((Input)aggInput.accept(this, context));
            }
            AggregationContext aggregationContext = new AggregationContext((AggregationFunction)impl, filter, inputs);
            this.aggregationContexts.add(aggregationContext);
            return null;
        }
    }
}

