/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression;

import io.crate.common.collections.Lists2;
import io.crate.data.Input;
import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.expression.FunctionExpression;
import io.crate.expression.symbol.AliasSymbol;
import io.crate.expression.symbol.DynamicReference;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.metadata.FunctionImplementation;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import java.util.List;
import java.util.Locale;

public class BaseImplementationSymbolVisitor<C>
extends SymbolVisitor<C, Input<?>> {
    protected final TransactionContext txnCtx;
    protected final NodeContext nodeCtx;

    public BaseImplementationSymbolVisitor(TransactionContext txnCtx, NodeContext nodeCtx) {
        this.txnCtx = txnCtx;
        this.nodeCtx = nodeCtx;
    }

    @Override
    public Input<?> visitFunction(Function function, C context) {
        Signature signature = function.signature();
        FunctionImplementation functionImplementation = this.nodeCtx.functions().getQualified(function, this.txnCtx.sessionSettings().searchPath());
        assert (functionImplementation != null) : "Function implementation not found using full qualified lookup";
        if (functionImplementation instanceof Scalar) {
            List<Symbol> arguments = function.arguments();
            Scalar scalarImpl = ((Scalar)functionImplementation).compile(arguments);
            Input[] argumentInputs = new Input[arguments.size()];
            int i = 0;
            for (Symbol argument : function.arguments()) {
                argumentInputs[i++] = (Input)argument.accept(this, context);
            }
            return new FunctionExpression(this.txnCtx, this.nodeCtx, scalarImpl, argumentInputs);
        }
        throw new UnsupportedFeatureException(String.format(Locale.ENGLISH, "Function %s(%s) is not a scalar function.", signature.getName(), Lists2.joinOn(", ", function.arguments(), x -> x.valueType().getName())));
    }

    @Override
    public Input<?> visitLiteral(Literal symbol, C context) {
        return symbol;
    }

    @Override
    public Input<?> visitDynamicReference(DynamicReference symbol, C context) {
        return (Input)this.visitReference(symbol, context);
    }

    @Override
    public Input<?> visitAlias(AliasSymbol aliasSymbol, C context) {
        return (Input)aliasSymbol.symbol().accept(this, context);
    }

    @Override
    protected Input<?> visitSymbol(Symbol symbol, C context) {
        throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Can't handle Symbol [%s: %s]", symbol.getClass().getSimpleName(), symbol));
    }
}

