/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression;

import io.crate.metadata.FunctionImplementation;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionProvider;
import io.crate.metadata.functions.Signature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.multibindings.MapBinder;

public abstract class AbstractFunctionModule<T extends FunctionImplementation>
extends AbstractModule {
    private HashMap<FunctionName, List<FunctionProvider>> functionImplementations = new HashMap();
    private MapBinder<FunctionName, List<FunctionProvider>> implementationsBinder;

    public void register(Signature signature, BiFunction<Signature, Signature, FunctionImplementation> factory) {
        List functions = this.functionImplementations.computeIfAbsent(signature.getName(), k -> new ArrayList());
        Optional<FunctionProvider> duplicate = functions.stream().filter(fr -> fr.getSignature().equals(signature)).findFirst();
        if (duplicate.isPresent()) {
            throw new IllegalStateException("A function already exists for signature = " + signature);
        }
        functions.add(new FunctionProvider(signature, factory));
    }

    public abstract void configureFunctions();

    @Override
    protected void configure() {
        this.configureFunctions();
        this.implementationsBinder = MapBinder.newMapBinder(this.binder(), new TypeLiteral<FunctionName>(){}, new TypeLiteral<List<FunctionProvider>>(){});
        for (Map.Entry<FunctionName, List<FunctionProvider>> entry : this.functionImplementations.entrySet()) {
            this.implementationsBinder.addBinding(entry.getKey()).toProvider(entry::getValue);
        }
        this.functionImplementations = null;
    }
}

