/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.support;

import io.crate.action.FutureActionListener;
import io.crate.exceptions.Exceptions;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

@Singleton
public class Transports {
    private final ClusterService clusterService;
    private final TransportService transportService;

    @Inject
    public Transports(ClusterService clusterService, TransportService transportService) {
        this.clusterService = clusterService;
        this.transportService = transportService;
    }

    public static <Req extends TransportRequest, Resp extends TransportResponse, Result> CompletableFuture<Result> execute(TransportAction<Req, Resp> transportAction, Req request, Function<? super Resp, Result> convertResponse) {
        FutureActionListener<? super Resp, Result> listener = new FutureActionListener<Resp, Result>(convertResponse);
        transportAction.execute(request, listener);
        return listener;
    }

    public <TRequest extends TransportRequest, TResponse extends TransportResponse> void sendRequest(String action, String node, TRequest request, ActionListener<TResponse> listener, TransportResponseHandler<TResponse> handler, TransportRequestOptions options) {
        DiscoveryNode discoveryNode = this.clusterService.state().nodes().get(node);
        if (discoveryNode == null) {
            listener.onFailure(new NodeNotConnectedException(null, String.format(Locale.ENGLISH, "node \"%s\" not found in cluster state!", node)));
            return;
        }
        try {
            this.transportService.sendRequest(discoveryNode, action, request, options, handler);
        }
        catch (Throwable t) {
            listener.onFailure(Exceptions.toRuntimeException(t));
        }
    }

    public <TRequest extends TransportRequest, TResponse extends TransportResponse> void sendRequest(String action, String node, TRequest request, ActionListener<TResponse> listener, TransportResponseHandler<TResponse> handler) {
        this.sendRequest(action, node, request, listener, handler, TransportRequestOptions.EMPTY);
    }
}

