/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.support;

import io.crate.common.unit.TimeValue;
import io.crate.exceptions.SQLExceptions;
import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;

public class RetryListener<TResp>
implements ActionListener<TResp> {
    private final ScheduledExecutorService scheduler;
    private final ActionListener<TResp> delegate;
    private final Iterator<TimeValue> delay;
    private final Runnable retryCommand;

    public RetryListener(ScheduledExecutorService scheduler, Consumer<ActionListener<TResp>> command, ActionListener<TResp> delegate, Iterable<TimeValue> backOffPolicy) {
        this.scheduler = scheduler;
        this.delegate = delegate;
        this.delay = backOffPolicy.iterator();
        this.retryCommand = () -> command.accept(this);
    }

    @Override
    public void onResponse(TResp response) {
        this.delegate.onResponse(response);
    }

    @Override
    public void onFailure(Exception e) {
        Throwable throwable = SQLExceptions.unwrap(e);
        if (throwable instanceof EsRejectedExecutionException && this.delay.hasNext()) {
            TimeValue currentDelay = this.delay.next();
            this.scheduler.schedule(this.retryCommand, currentDelay.millis(), TimeUnit.MILLISECONDS);
        } else {
            this.delegate.onFailure(e);
        }
    }
}

