/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.support;

import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.data.SentinelRow;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.elasticsearch.action.ActionListener;

public class OneRowActionListener<Response>
implements ActionListener<Response>,
BiConsumer<Response, Throwable> {
    private final RowConsumer consumer;
    private final Function<? super Response, ? extends Row> toRowFunction;

    public OneRowActionListener(RowConsumer consumer, Function<? super Response, ? extends Row> toRowFunction) {
        this.consumer = consumer;
        this.toRowFunction = toRowFunction;
    }

    @Override
    public void onResponse(Response response) {
        Row row;
        try {
            row = this.toRowFunction.apply(response);
        }
        catch (Throwable t) {
            this.consumer.accept(null, t);
            return;
        }
        this.consumer.accept(InMemoryBatchIterator.of(row, SentinelRow.SENTINEL), null);
    }

    @Override
    public void onFailure(@Nonnull Exception e) {
        this.consumer.accept(null, e);
    }

    @Override
    public void accept(Response response, Throwable t) {
        if (t == null) {
            this.onResponse(response);
        } else {
            this.consumer.accept(null, t);
        }
    }
}

