/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.support;

import com.google.common.collect.ImmutableList;
import io.crate.exceptions.Exceptions;
import io.crate.exceptions.MultiException;
import io.crate.execution.support.ChainableAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nullable;

public class ChainableActions {
    public static <R> CompletableFuture<R> run(List<? extends ChainableAction<R>> actions) {
        assert (actions.size() > 0) : "Empty list of ChainableActions";
        ArrayList previousActions = new ArrayList(actions.size());
        ChainableAction<R> lastAction = actions.get(0);
        CompletionStage<Object> future = lastAction.doIt();
        Result<Object> result = new Result<Object>(null, null);
        if (actions.size() > 1) {
            for (int i = 1; i < actions.size(); ++i) {
                ChainableAction action = actions.get(i);
                previousActions.add(lastAction);
                lastAction = action;
                future = ((CompletableFuture)future.handle(result::addResultAndError)).thenCompose(r -> ChainableActions.runOrRollbackOnErrors(r, action, ImmutableList.copyOf((Collection)previousActions)));
            }
        } else {
            previousActions.add(lastAction);
        }
        return ((CompletableFuture)future.handle(result::addResultAndError)).thenCompose(r -> ChainableActions.rollbackOnErrors(r, previousActions));
    }

    private static <R> CompletableFuture<R> runOrRollbackOnErrors(Result<R> result, ChainableAction<R> action, List<ChainableAction<R>> previousActions) {
        if (result.error != null) {
            return ChainableActions.rollbackOnErrors(result, previousActions);
        }
        return action.doIt();
    }

    private static <R> CompletableFuture<R> rollbackOnErrors(Result<R> result, List<ChainableAction<R>> previousActions) {
        if (result.error != null) {
            if (result.undoDone) {
                Exceptions.rethrowUnchecked(result.error);
                return CompletableFuture.failedFuture(result.error);
            }
            int previousActionsSize = previousActions.size();
            assert (previousActionsSize > 0) : "previous actions cannot be empty. if only one action was executed it should be part of the previous actions in order to undo it";
            CompletionStage<Object> previousActionUndo = previousActions.get(previousActionsSize - 1).undo();
            for (int i = previousActionsSize - 2; i >= 0; --i) {
                ChainableAction previousAction = previousActions.get(i);
                previousActionUndo = ((CompletableFuture)previousActionUndo.handle(result::addResultAndError)).thenCompose(r -> {
                    if (r.errorOnUndo) {
                        Exceptions.rethrowUnchecked(r.error);
                    }
                    return previousAction.undo();
                });
            }
            result.undoDone = true;
            return ((CompletableFuture)previousActionUndo.handle(result::addResultAndError)).thenCompose(r -> {
                Exceptions.rethrowUnchecked(result.error);
                return CompletableFuture.failedFuture(result.error);
            });
        }
        return CompletableFuture.completedFuture(result.result);
    }

    private static Throwable unwrap(@Nullable Throwable t) {
        if (t instanceof CompletionException) {
            return t.getCause();
        }
        return t;
    }

    private static class Result<R> {
        @Nullable
        private R result;
        @Nullable
        private Throwable error;
        private boolean errorOnUndo = false;
        private boolean undoDone = false;

        public Result(@Nullable R result, @Nullable Throwable error) {
            this.result = result;
            this.error = error;
        }

        Result<R> addResultAndError(@Nullable R result, @Nullable Throwable t) {
            if (result != null) {
                this.result = result;
            }
            if ((t = ChainableActions.unwrap(t)) != null) {
                if (this.error != null && this.error != t) {
                    this.error = MultiException.of(this.error, t);
                    this.errorOnUndo = true;
                } else {
                    this.error = t;
                }
            }
            return this;
        }
    }
}

