/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.support;

import io.crate.common.unit.TimeValue;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.master.AcknowledgedResponse;

public final class ActionListeners {
    private ActionListeners() {
    }

    public static <T extends AcknowledgedResponse> ActionListener<T> waitForShards(ActionListener<T> delegate, ActiveShardsObserver observer, TimeValue timeout, Runnable onShardsNotAcknowledged, Supplier<String[]> indices) {
        return ActionListener.wrap(resp -> {
            if (resp.isAcknowledged()) {
                observer.waitForActiveShards((String[])indices.get(), ActiveShardCount.DEFAULT, timeout, shardsAcknowledged -> {
                    if (!shardsAcknowledged.booleanValue()) {
                        onShardsNotAcknowledged.run();
                    }
                    delegate.onResponse(resp);
                }, delegate::onFailure);
            } else {
                delegate.onResponse(resp);
            }
        }, delegate::onFailure);
    }
}

