/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs.transport;

import io.crate.concurrent.CompletableFutures;
import io.crate.execution.engine.distribution.StreamBucket;
import io.crate.execution.jobs.InstrumentedIndexSearcher;
import io.crate.execution.jobs.JobSetup;
import io.crate.execution.jobs.RootTask;
import io.crate.execution.jobs.SharedShardContexts;
import io.crate.execution.jobs.TasksService;
import io.crate.execution.jobs.transport.JobRequest;
import io.crate.execution.jobs.transport.JobResponse;
import io.crate.execution.support.NodeAction;
import io.crate.execution.support.NodeActionRequestHandler;
import io.crate.execution.support.Transports;
import io.crate.profile.ProfilingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.search.profile.query.QueryProfiler;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportJobAction
implements NodeAction<JobRequest, JobResponse> {
    private static final String ACTION_NAME = "internal:crate:sql/job";
    private static final String EXECUTOR = "search";
    private final IndicesService indicesService;
    private final Transports transports;
    private final TasksService tasksService;
    private final JobSetup jobSetup;

    @Inject
    public TransportJobAction(TransportService transportService, IndicesService indicesService, Transports transports, TasksService tasksService, JobSetup jobSetup) {
        this.indicesService = indicesService;
        this.transports = transports;
        this.tasksService = tasksService;
        this.jobSetup = jobSetup;
        transportService.registerRequestHandler(ACTION_NAME, EXECUTOR, JobRequest::new, new NodeActionRequestHandler<JobRequest, JobResponse>(this));
    }

    public void execute(String node, JobRequest request, ActionListener<JobResponse> listener) {
        this.transports.sendRequest(ACTION_NAME, node, request, listener, new ActionListenerResponseHandler<JobResponse>(listener, JobResponse::new));
    }

    @Override
    public CompletableFuture<JobResponse> nodeOperation(JobRequest request) {
        RootTask.Builder contextBuilder = this.tasksService.newBuilder(request.jobId(), request.sessionSettings().userName(), request.coordinatorNodeId(), Collections.emptySet());
        SharedShardContexts sharedShardContexts = this.maybeInstrumentProfiler(request.enableProfiling(), contextBuilder);
        List<CompletableFuture<StreamBucket>> directResponseFutures = this.jobSetup.prepareOnRemote(request.sessionSettings(), request.nodeOperations(), contextBuilder, sharedShardContexts);
        try {
            RootTask context = this.tasksService.createTask(contextBuilder);
            context.start();
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
        if (directResponseFutures.size() == 0) {
            return CompletableFuture.completedFuture(new JobResponse(List.of()));
        }
        return CompletableFutures.allAsList(directResponseFutures).thenApply(JobResponse::new);
    }

    private SharedShardContexts maybeInstrumentProfiler(boolean enableProfiling, RootTask.Builder contextBuilder) {
        if (enableProfiling) {
            ArrayList<QueryProfiler> profilers = new ArrayList<QueryProfiler>();
            ProfilingContext profilingContext = new ProfilingContext(profilers);
            contextBuilder.profilingContext(profilingContext);
            return new SharedShardContexts(this.indicesService, indexSearcher -> {
                QueryProfiler queryProfiler = new QueryProfiler();
                profilers.add(queryProfiler);
                return new InstrumentedIndexSearcher((Engine.Searcher)indexSearcher, queryProfiler);
            });
        }
        return new SharedShardContexts(this.indicesService, UnaryOperator.identity());
    }
}

