/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs.transport;

import io.crate.auth.user.User;
import io.crate.execution.jobs.TasksService;
import io.crate.execution.jobs.kill.KillJobsRequest;
import io.crate.execution.jobs.kill.TransportKillJobsNodeAction;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportConnectionListener;
import org.elasticsearch.transport.TransportService;

@Singleton
public class NodeDisconnectJobMonitorService
extends AbstractLifecycleComponent
implements TransportConnectionListener {
    private final TasksService tasksService;
    private final TransportService transportService;
    private final TransportKillJobsNodeAction killJobsNodeAction;
    private static final Logger LOGGER = LogManager.getLogger(NodeDisconnectJobMonitorService.class);

    @Inject
    public NodeDisconnectJobMonitorService(TasksService tasksService, TransportService transportService, TransportKillJobsNodeAction killJobsNodeAction) {
        this.tasksService = tasksService;
        this.transportService = transportService;
        this.killJobsNodeAction = killJobsNodeAction;
    }

    @Override
    protected void doStart() {
        this.transportService.addConnectionListener(this);
    }

    @Override
    protected void doStop() {
        this.transportService.removeConnectionListener(this);
    }

    @Override
    protected void doClose() {
    }

    @Override
    public void onNodeConnected(DiscoveryNode node, Transport.Connection connection) {
    }

    @Override
    public void onNodeDisconnected(DiscoveryNode node, Transport.Connection connection) {
        this.killJobsCoordinatedBy(node);
        this.broadcastKillToParticipatingNodes(node);
    }

    private void broadcastKillToParticipatingNodes(DiscoveryNode deadNode) {
        List<UUID> affectedJobs = this.tasksService.getJobIdsByParticipatingNodes(deadNode.getId()).collect(Collectors.toList());
        if (affectedJobs.isEmpty()) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Broadcasting kill for {} jobs because they involved disconnected node={}", (Object)affectedJobs.size(), (Object)deadNode.getId());
        }
        List<String> excludedNodeIds = Collections.singletonList(deadNode.getId());
        KillJobsRequest killRequest = new KillJobsRequest(affectedJobs, User.CRATE_USER.name(), "Participating node=" + deadNode.getName() + " disconnected.");
        this.killJobsNodeAction.broadcast(killRequest, (ActionListener)new ActionListener<Long>(){

            @Override
            public void onResponse(Long numKilled) {
            }

            @Override
            public void onFailure(Exception e) {
                LOGGER.warn("failed to send kill request to nodes");
            }
        }, excludedNodeIds);
    }

    private void killJobsCoordinatedBy(DiscoveryNode deadNode) {
        List<UUID> jobsStartedByDeadNode = this.tasksService.getJobIdsByCoordinatorNode(deadNode.getId()).collect(Collectors.toList());
        if (jobsStartedByDeadNode.isEmpty()) {
            return;
        }
        this.tasksService.killJobs(jobsStartedByDeadNode, User.CRATE_USER.name(), "Participating node=" + deadNode.getName() + " disconnected.");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Killed {} jobs started by disconnected node={}", (Object)jobsStartedByDeadNode.size(), (Object)deadNode.getId());
        }
    }
}

