/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs.transport;

import io.crate.Streamer;
import io.crate.execution.engine.distribution.StreamBucket;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportResponse;

public class JobResponse
extends TransportResponse {
    private final List<StreamBucket> directResponse;

    public JobResponse(@Nonnull List<StreamBucket> directResponse) {
        this.directResponse = directResponse;
    }

    public List<StreamBucket> getDirectResponses(Streamer<?>[] streamers) {
        for (StreamBucket bucket : this.directResponse) {
            bucket.streamers(streamers);
        }
        return this.directResponse;
    }

    public boolean hasDirectResponses() {
        return !this.directResponse.isEmpty();
    }

    public JobResponse(StreamInput in) throws IOException {
        int size = in.readVInt();
        this.directResponse = new ArrayList<StreamBucket>(size);
        for (int i = 0; i < size; ++i) {
            StreamBucket bucket = new StreamBucket(in);
            this.directResponse.add(bucket);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.directResponse.size());
        for (StreamBucket bucket : this.directResponse) {
            bucket.writeTo(out);
        }
    }
}

