/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs.kill;

import io.crate.execution.jobs.TasksService;
import io.crate.execution.jobs.kill.KillResponse;
import io.crate.execution.support.MultiActionListener;
import io.crate.execution.support.NodeAction;
import io.crate.execution.support.NodeActionRequestHandler;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;

abstract class TransportKillNodeAction<Request extends TransportRequest>
implements NodeAction<Request, KillResponse>,
Writeable.Reader<Request> {
    protected final TasksService tasksService;
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    protected final String name;
    private final Writeable.Reader<Request> reader;

    TransportKillNodeAction(String name, TasksService tasksService, ClusterService clusterService, TransportService transportService, Writeable.Reader<Request> reader) {
        this.tasksService = tasksService;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.reader = reader;
        this.name = name;
        transportService.registerRequestHandler(name, "generic", reader, new NodeActionRequestHandler(this));
    }

    protected abstract CompletableFuture<Integer> doKill(Request var1);

    @Override
    public CompletableFuture<KillResponse> nodeOperation(Request request) {
        return this.doKill(request).thenApply(KillResponse::new);
    }

    @Override
    public Request read(StreamInput in) throws IOException {
        return (Request)((TransportRequest)this.reader.read(in));
    }

    public void broadcast(Request request, ActionListener<Long> listener) {
        this.broadcast(request, listener, Collections.emptyList());
    }

    public void broadcast(Request request, ActionListener<Long> listener, Collection<String> excludedNodeIds) {
        Stream<DiscoveryNode> nodes = StreamSupport.stream(this.clusterService.state().nodes().spliterator(), false);
        Collection filteredNodes = nodes.filter(node -> !excludedNodeIds.contains(node.getId())).collect(Collectors.toList());
        MultiActionListener multiListener = new MultiActionListener(filteredNodes.size(), Collectors.summingLong(KillResponse::numKilled), listener);
        ActionListenerResponseHandler<KillResponse> responseHandler = new ActionListenerResponseHandler<KillResponse>(multiListener, KillResponse::new);
        for (DiscoveryNode node2 : filteredNodes) {
            this.transportService.sendRequest(node2, this.name, (TransportRequest)request, responseHandler);
        }
    }
}

