/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs.kill;

import io.crate.execution.jobs.TasksService;
import io.crate.execution.jobs.kill.KillJobsRequest;
import io.crate.execution.jobs.kill.TransportKillNodeAction;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportKillJobsNodeAction
extends TransportKillNodeAction<KillJobsRequest> {
    @Inject
    public TransportKillJobsNodeAction(TasksService tasksService, ClusterService clusterService, TransportService transportService) {
        super("internal:crate:sql/kill/jobs", tasksService, clusterService, transportService, KillJobsRequest::new);
    }

    @Override
    protected CompletableFuture<Integer> doKill(KillJobsRequest request) {
        return this.tasksService.killJobs(request.toKill(), request.userName(), request.reason());
    }

    @Override
    public KillJobsRequest read(StreamInput in) throws IOException {
        return new KillJobsRequest(in);
    }
}

