/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs.kill;

import io.crate.auth.user.User;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nullable;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;

public class KillJobsRequest
extends TransportRequest {
    private final Collection<UUID> toKill;
    private final String userName;
    @Nullable
    private final String reason;

    public KillJobsRequest(Collection<UUID> jobsToKill, String userName, @Nullable String reason) {
        this.toKill = jobsToKill;
        this.userName = userName;
        this.reason = reason;
    }

    Collection<UUID> toKill() {
        return this.toKill;
    }

    public KillJobsRequest(StreamInput in) throws IOException {
        super(in);
        int numJobs = in.readVInt();
        this.toKill = new ArrayList<UUID>(numJobs);
        for (int i = 0; i < numJobs; ++i) {
            UUID job = new UUID(in.readLong(), in.readLong());
            this.toKill.add(job);
        }
        this.reason = in.getVersion().onOrAfter(Version.V_4_1_0) ? in.readOptionalString() : null;
        this.userName = in.getVersion().onOrAfter(Version.V_4_3_0) ? in.readString() : User.CRATE_USER.name();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        int numJobs = this.toKill.size();
        out.writeVInt(numJobs);
        for (UUID job : this.toKill) {
            out.writeLong(job.getMostSignificantBits());
            out.writeLong(job.getLeastSignificantBits());
        }
        if (out.getVersion().onOrAfter(Version.V_4_1_0)) {
            out.writeOptionalString(this.reason);
        }
        if (out.getVersion().onOrAfter(Version.V_4_3_0)) {
            out.writeString(this.userName);
        }
    }

    public String toString() {
        return "KillJobsRequest{" + this.toKill + "}";
    }

    @Nullable
    public String reason() {
        return this.reason;
    }

    public String userName() {
        return this.userName;
    }
}

