/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs;

import io.crate.execution.jobs.SharedShardContext;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.concurrent.NotThreadSafe;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;

@NotThreadSafe
public class SharedShardContexts {
    private final IndicesService indicesService;
    private final UnaryOperator<Engine.Searcher> wrapSearcher;
    private final Map<ShardId, SharedShardContext> allocatedShards = new HashMap<ShardId, SharedShardContext>();
    private int readerId = 0;

    public SharedShardContexts(IndicesService indicesService, UnaryOperator<Engine.Searcher> wrapSearcher) {
        this.indicesService = indicesService;
        this.wrapSearcher = wrapSearcher;
    }

    public SharedShardContext createContext(ShardId shardId, int readerId) throws IndexNotFoundException {
        assert (!this.allocatedShards.containsKey(shardId)) : "shardId shouldn't have been allocated yet";
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        SharedShardContext sharedShardContext = new SharedShardContext(indexService, shardId, readerId, this.wrapSearcher);
        this.allocatedShards.put(shardId, sharedShardContext);
        return sharedShardContext;
    }

    public SharedShardContext getOrCreateContext(ShardId shardId) throws IndexNotFoundException {
        SharedShardContext sharedShardContext = this.allocatedShards.get(shardId);
        if (sharedShardContext == null) {
            IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
            sharedShardContext = new SharedShardContext(indexService, shardId, this.readerId, this.wrapSearcher);
            this.allocatedShards.put(shardId, sharedShardContext);
            ++this.readerId;
        }
        return sharedShardContext;
    }

    public String toString() {
        return "SharedShardContexts{allocatedShards=" + this.allocatedShards.keySet() + "}";
    }
}

