/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs;

import io.crate.common.collections.RefCountedItem;
import java.util.function.UnaryOperator;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.lucene.search.IndexSearcher;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;

@NotThreadSafe
public class SharedShardContext {
    private final IndexService indexService;
    private final int readerId;
    private final IndexShard indexShard;
    private final RefCountedItem<Engine.Searcher> searcher;

    SharedShardContext(IndexService indexService, ShardId shardId, int readerId, UnaryOperator<Engine.Searcher> wrapSearcher) {
        this.indexService = indexService;
        this.indexShard = indexService.getShard(shardId.id());
        this.readerId = readerId;
        this.searcher = new RefCountedItem<Engine.Searcher>(source -> (Engine.Searcher)wrapSearcher.apply(this.indexShard.acquireSearcher((String)source)), Engine.Searcher::close);
    }

    public RefCountedItem<? extends IndexSearcher> acquireSearcher(String source) throws IndexNotFoundException {
        this.searcher.markAcquired(source);
        return this.searcher;
    }

    public IndexShard indexShard() {
        return this.indexShard;
    }

    public IndexService indexService() {
        return this.indexService;
    }

    public int readerId() {
        return this.readerId;
    }
}

