/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class NodeJobsCounter {
    public static final long MAX_NODE_CONCURRENT_OPERATIONS = 5L;
    private final AtomicLong unknownNodeCount = new AtomicLong();
    private final Map<String, long[]> operationsCountPerNode = new ConcurrentHashMap<String, long[]>();
    private static final BiFunction<String, long[], long[]> INCREMENT_COUNTER_FOR_NODE = (node, count) -> {
        if (count == null) {
            count = new long[]{1L};
        } else {
            count[0] = count[0] + 1L;
        }
        return count;
    };
    private static final BiFunction<String, long[], long[]> DECREMENT_COUNTER_FOR_NODE = (id, count) -> {
        if (count == null) {
            count = new long[]{0L};
        } else {
            count[0] = count[0] - 1L;
        }
        return count;
    };

    public void increment(@Nullable String nodeId) {
        if (nodeId == null) {
            this.unknownNodeCount.incrementAndGet();
        } else {
            this.operationsCountPerNode.compute(nodeId, INCREMENT_COUNTER_FOR_NODE);
        }
    }

    public void decrement(@Nullable String nodeId) {
        if (nodeId == null) {
            this.unknownNodeCount.decrementAndGet();
        } else {
            this.operationsCountPerNode.compute(nodeId, DECREMENT_COUNTER_FOR_NODE);
        }
    }

    public long getInProgressJobsForNode(@Nullable String nodeId) {
        if (nodeId == null) {
            return this.unknownNodeCount.get();
        }
        long[] countPerNode = this.operationsCountPerNode.get(nodeId);
        return countPerNode == null ? 0L : countPerNode[0];
    }
}

