/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs;

import io.crate.concurrent.CompletionListenable;
import io.crate.execution.dsl.phases.JoinPhase;
import io.crate.execution.jobs.AbstractTask;
import io.crate.execution.jobs.DownstreamRXTask;
import io.crate.execution.jobs.PageBucketReceiver;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

class JoinTask
extends AbstractTask
implements DownstreamRXTask {
    private final JoinPhase joinPhase;
    @Nullable
    private final PageBucketReceiver leftPageBucketReceiver;
    @Nullable
    private final PageBucketReceiver rightPageBucketReceiver;

    JoinTask(JoinPhase joinPhase, CompletionListenable<?> completionListenable, @Nullable PageBucketReceiver leftPageBucketReceiver, @Nullable PageBucketReceiver rightPageBucketReceiver) {
        super(joinPhase.phaseId());
        this.joinPhase = joinPhase;
        this.leftPageBucketReceiver = leftPageBucketReceiver;
        this.rightPageBucketReceiver = rightPageBucketReceiver;
        completionListenable.completionFuture().whenComplete((BiConsumer)JoinTask.closeOrKill(this));
    }

    @Override
    public String name() {
        return this.joinPhase.name();
    }

    @Override
    public long bytesUsed() {
        return -1L;
    }

    @Override
    protected void innerKill(@Nullable Throwable t) {
    }

    @Override
    public PageBucketReceiver getBucketReceiver(byte inputId) {
        assert (inputId < 2) : "Only 0 and 1 inputId's supported";
        if (inputId == 0) {
            return this.leftPageBucketReceiver;
        }
        return this.rightPageBucketReceiver;
    }

    public String toString() {
        return "JoinTask{id=" + this.id() + ", leftCtx=" + this.leftPageBucketReceiver + ", rightCtx=" + this.rightPageBucketReceiver + ", closed=" + this.isClosed() + "}";
    }
}

