/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs;

import com.carrotsearch.hppc.IntIndexedContainer;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.data.SentinelRow;
import io.crate.execution.dsl.phases.CountPhase;
import io.crate.execution.engine.collect.count.CountOperation;
import io.crate.execution.jobs.AbstractTask;
import io.crate.metadata.TransactionContext;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class CountTask
extends AbstractTask {
    private final CountPhase countPhase;
    private final TransactionContext txnCtx;
    private final CountOperation countOperation;
    private final RowConsumer consumer;
    private final Map<String, IntIndexedContainer> indexShardMap;
    private CompletableFuture<Long> countFuture;

    CountTask(CountPhase countPhase, TransactionContext txnCtx, CountOperation countOperation, RowConsumer consumer, Map<String, IntIndexedContainer> indexShardMap) {
        super(countPhase.phaseId());
        this.countPhase = countPhase;
        this.txnCtx = txnCtx;
        this.countOperation = countOperation;
        this.consumer = consumer;
        this.indexShardMap = indexShardMap;
    }

    @Override
    public synchronized void innerStart() {
        try {
            this.countFuture = this.countOperation.count(this.txnCtx, this.indexShardMap, this.countPhase.where());
        }
        catch (Throwable t) {
            this.consumer.accept(null, t);
            return;
        }
        this.countFuture.whenComplete((rowCount, failure) -> {
            if (rowCount == null) {
                this.consumer.accept(null, (Throwable)failure);
                this.kill((Throwable)failure);
            } else {
                this.consumer.accept(InMemoryBatchIterator.of(new Row1(rowCount), SentinelRow.SENTINEL), null);
                this.close();
            }
        });
    }

    @Override
    public synchronized void innerKill(@Nonnull Throwable throwable) {
        if (this.countFuture == null) {
            this.consumer.accept(null, throwable);
        } else {
            this.countFuture.cancel(true);
        }
    }

    @Override
    public String name() {
        return this.countPhase.name();
    }

    @Override
    public long bytesUsed() {
        return -1L;
    }
}

