/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs;

import io.crate.execution.jobs.Task;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;

public abstract class AbstractTask
implements Task {
    protected final int id;
    private final AtomicBoolean firstClose = new AtomicBoolean(false);
    private final CompletableFuture<Void> future = new CompletableFuture();

    protected AbstractTask(int id) {
        this.id = id;
    }

    @Override
    public int id() {
        return this.id;
    }

    protected static BiConsumer<? super Object, Throwable> closeOrKill(AbstractTask t) {
        return (result, err) -> {
            if (err == null) {
                t.close();
            } else {
                t.kill((Throwable)err);
            }
        };
    }

    protected void innerStart() {
    }

    @Override
    public final void start() {
        if (!this.firstClose.get()) {
            try {
                this.innerStart();
            }
            catch (Throwable t) {
                this.kill(t);
            }
        }
    }

    protected void innerClose() {
    }

    protected void close() {
        if (this.firstClose.compareAndSet(false, true)) {
            try {
                this.innerClose();
                this.future.complete(null);
            }
            catch (Throwable t) {
                this.future.completeExceptionally(t);
            }
        }
    }

    protected void innerKill(@Nonnull Throwable t) {
    }

    @Override
    public final void kill(@Nonnull Throwable t) {
        if (this.firstClose.compareAndSet(false, true)) {
            try {
                this.innerKill(t);
            }
            finally {
                this.future.completeExceptionally(t);
            }
        }
    }

    @Override
    public CompletableFuture<Void> completionFuture() {
        return this.future;
    }

    protected synchronized boolean isClosed() {
        return this.firstClose.get() || this.future.isDone();
    }
}

