/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.window;

import io.crate.analyze.FrameBoundDefinition;
import io.crate.analyze.OrderBy;
import io.crate.analyze.SymbolEvaluator;
import io.crate.analyze.WindowDefinition;
import io.crate.analyze.WindowFrameDefinition;
import io.crate.breaker.RamAccounting;
import io.crate.breaker.RowAccountingWithEstimators;
import io.crate.data.Input;
import io.crate.data.Projector;
import io.crate.data.Row;
import io.crate.execution.dsl.projection.WindowAggProjection;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.sort.Comparators;
import io.crate.execution.engine.window.AggregateToWindowFunctionAdapter;
import io.crate.execution.engine.window.ArithmeticOperatorsFactory;
import io.crate.execution.engine.window.ComputeFrameBoundary;
import io.crate.execution.engine.window.WindowFunction;
import io.crate.execution.engine.window.WindowFunctionBatchIterator;
import io.crate.expression.ExpressionsInput;
import io.crate.expression.InputFactory;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.Symbols;
import io.crate.memory.MemoryManager;
import io.crate.metadata.FunctionImplementation;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.sql.tree.WindowFrame;
import io.crate.types.DataType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.elasticsearch.Version;

public class WindowProjector {
    public static Projector fromProjection(WindowAggProjection projection, NodeContext nodeCtx, InputFactory inputFactory, TransactionContext txnCtx, RamAccounting ramAccounting, MemoryManager memoryManager, Version minNodeVersion, Version indexVersionCreated, IntSupplier numThreads, Executor executor) {
        List<io.crate.expression.symbol.WindowFunction> windowFunctionSymbols = projection.windowFunctions();
        int numWindowFunctions = windowFunctionSymbols.size();
        ArrayList<WindowFunction> windowFunctions = new ArrayList<WindowFunction>(numWindowFunctions);
        ArrayList windowFuncArgsExpressions = new ArrayList(numWindowFunctions);
        Input[][] windowFuncArgsInputs = new Input[numWindowFunctions][];
        for (int idx = 0; idx < numWindowFunctions; ++idx) {
            io.crate.expression.symbol.WindowFunction windowFunctionSymbol = windowFunctionSymbols.get(idx);
            InputFactory.Context<CollectExpression<Row, ?>> ctx = inputFactory.ctxForInputColumns(txnCtx);
            ctx.add(windowFunctionSymbol.arguments());
            FunctionImplementation impl = nodeCtx.functions().getQualified(windowFunctionSymbol, txnCtx.sessionSettings().searchPath());
            assert (impl != null) : "Function implementation not found using full qualified lookup";
            if (impl instanceof AggregationFunction) {
                InputFactory.Context<CollectExpression<Row, ?>> filterInputFactoryCtx = inputFactory.ctxForInputColumns(txnCtx);
                Symbol filterSymbol = windowFunctionSymbol.filter();
                Literal<Boolean> filterInput = filterSymbol == null ? Literal.BOOLEAN_TRUE : filterInputFactoryCtx.add(filterSymbol);
                ExpressionsInput<Row, Boolean> filter = new ExpressionsInput<Row, Boolean>(filterInput, filterInputFactoryCtx.expressions());
                windowFunctions.add(new AggregateToWindowFunctionAdapter((AggregationFunction)impl, filter, indexVersionCreated, ramAccounting, memoryManager, minNodeVersion));
            } else if (impl instanceof WindowFunction) {
                windowFunctions.add((WindowFunction)impl);
            } else {
                throw new AssertionError((Object)"Function needs to be either a window or an aggregate function");
            }
            windowFuncArgsExpressions.addAll(ctx.expressions());
            windowFuncArgsInputs[idx] = ctx.topLevelInputs().toArray(new Input[0]);
        }
        WindowDefinition windowDefinition = projection.windowDefinition();
        List<Symbol> partitions = windowDefinition.partitions();
        Supplier createInputFactoryContext = () -> inputFactory.ctxForInputColumns(txnCtx);
        int arrayListElementOverHead = 32;
        RowAccountingWithEstimators accounting = new RowAccountingWithEstimators(Symbols.typeView(projection.standalone()), ramAccounting, arrayListElementOverHead);
        Comparator<Object[]> cmpPartitionBy = partitions.isEmpty() ? null : Comparators.createComparator(createInputFactoryContext, new OrderBy(windowDefinition.partitions()));
        Comparator<Object[]> cmpOrderBy = Comparators.createComparator(createInputFactoryContext, windowDefinition.orderBy());
        int numCellsInSourceRow = projection.standalone().size();
        ComputeFrameBoundary<Object[]> computeFrameStart = WindowProjector.createComputeStartFrameBoundary(numCellsInSourceRow, txnCtx, nodeCtx, windowDefinition, cmpOrderBy);
        ComputeFrameBoundary<Object[]> computeFrameEnd = WindowProjector.createComputeEndFrameBoundary(numCellsInSourceRow, txnCtx, nodeCtx, windowDefinition, cmpOrderBy);
        return sourceRows -> WindowFunctionBatchIterator.of(sourceRows, accounting, computeFrameStart, computeFrameEnd, cmpPartitionBy, cmpOrderBy, numCellsInSourceRow, numThreads, executor, windowFunctions, windowFuncArgsExpressions, windowFuncArgsInputs);
    }

    static ComputeFrameBoundary<Object[]> createComputeEndFrameBoundary(int numCellsInSourceRow, TransactionContext txnCtx, NodeContext nodeCtx, WindowDefinition windowDefinition, Comparator<Object[]> cmpOrderBy) {
        WindowFrameDefinition frameDefinition = windowDefinition.windowFrameDefinition();
        FrameBoundDefinition frameBoundEnd = frameDefinition.end();
        WindowFrame.Mode framingMode = frameDefinition.mode();
        DataType<?> offsetType = frameBoundEnd.value().valueType();
        Object offsetValue = SymbolEvaluator.evaluateWithoutParams(txnCtx, nodeCtx, frameBoundEnd.value());
        Object[] endProbeValues = new Object[numCellsInSourceRow];
        BiFunction<Object[], Object[], Object[]> updateProbeValues = offsetValue != null && framingMode == WindowFrame.Mode.RANGE ? WindowProjector.createUpdateProbeValueFunction(windowDefinition, ArithmeticOperatorsFactory::getAddFunction, offsetValue, offsetType) : (currentRow, x) -> x;
        return (partitionStart, partitionEnd, currentIndex, sortedRows) -> frameBoundEnd.type().getEnd(framingMode, partitionStart, partitionEnd, currentIndex, offsetValue, (Object[])updateProbeValues.apply((Object[])sortedRows.get(currentIndex), endProbeValues), cmpOrderBy, sortedRows);
    }

    static ComputeFrameBoundary<Object[]> createComputeStartFrameBoundary(int numCellsInSourceRow, TransactionContext txnCtx, NodeContext nodeCtx, WindowDefinition windowDefinition, @Nullable Comparator<Object[]> cmpOrderBy) {
        WindowFrameDefinition frameDefinition = windowDefinition.windowFrameDefinition();
        FrameBoundDefinition frameBoundStart = frameDefinition.start();
        WindowFrame.Mode framingMode = frameDefinition.mode();
        DataType<?> offsetType = frameBoundStart.value().valueType();
        Object offsetValue = SymbolEvaluator.evaluateWithoutParams(txnCtx, nodeCtx, frameBoundStart.value());
        Object[] startProbeValues = new Object[numCellsInSourceRow];
        BiFunction<Object[], Object[], Object[]> updateStartProbeValue = offsetValue != null && framingMode == WindowFrame.Mode.RANGE ? WindowProjector.createUpdateProbeValueFunction(windowDefinition, ArithmeticOperatorsFactory::getSubtractFunction, offsetValue, offsetType) : (currentRow, x) -> x;
        return (partitionStart, partitionEnd, currentIndex, sortedRows) -> frameBoundStart.type().getStart(framingMode, partitionStart, partitionEnd, currentIndex, offsetValue, (Object[])updateStartProbeValue.apply((Object[])sortedRows.get(currentIndex), startProbeValues), cmpOrderBy, sortedRows);
    }

    private static BiFunction<Object[], Object[], Object[]> createUpdateProbeValueFunction(WindowDefinition windowDefinition, BiFunction<DataType<?>, DataType<?>, BiFunction> getOffsetApplicationFunction, Object offsetValue, DataType<?> offsetType) {
        int offsetColumnPosition;
        OrderBy windowOrdering = windowDefinition.orderBy();
        assert (windowOrdering != null) : "The window definition must be ordered if custom offsets are specified";
        List<Symbol> orderBySymbols = windowOrdering.orderBySymbols();
        if (orderBySymbols.size() != 1) {
            throw new IllegalArgumentException("Must have exactly 1 ORDER BY expression if using <offset> FOLLOWING/PRECEDING");
        }
        Symbol orderSymbol = orderBySymbols.get(0);
        BiFunction applyOffsetOnOrderingValue = getOffsetApplicationFunction.apply(orderSymbol.valueType(), offsetType);
        if (orderSymbol.symbolType() == SymbolType.LITERAL) {
            offsetColumnPosition = -1;
        } else {
            assert (orderSymbol instanceof InputColumn) : "ORDER BY expression must resolve to an InputColumn, but got: " + orderSymbol;
            offsetColumnPosition = ((InputColumn)orderSymbol).index();
        }
        Object finalOffsetValue = offsetType.id() == 17 ? offsetType.sanitizeValue(offsetValue) : orderSymbol.valueType().sanitizeValue(offsetValue);
        return (currentRow, x) -> {
            if (offsetColumnPosition != -1) {
                x[offsetColumnPosition] = applyOffsetOnOrderingValue.apply(currentRow[offsetColumnPosition], finalOffsetValue);
            }
            return x;
        };
    }
}

