/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.window;

import io.crate.expression.scalar.arithmetic.IntervalTimestampArithmeticScalar;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;

class ArithmeticOperatorsFactory {
    private static final BinaryOperator<Double> ADD_DOUBLE_FUNCTION = Double::sum;
    private static final BinaryOperator<Integer> ADD_INTEGER_FUNCTION = Integer::sum;
    private static final BinaryOperator<Long> ADD_LONG_FUNCTION = Long::sum;
    private static final BinaryOperator<Float> ADD_FLOAT_FUNCTION = Float::sum;
    private static final BinaryOperator<Double> SUB_DOUBLE_FUNCTION = (arg0, arg1) -> arg0 - arg1;
    private static final BinaryOperator<Integer> SUB_INTEGER_FUNCTION = (arg0, arg1) -> arg0 - arg1;
    private static final BinaryOperator<Long> SUB_LONG_FUNCTION = (arg0, arg1) -> arg0 - arg1;
    private static final BinaryOperator<Float> SUB_FLOAT_FUNCTION = (arg0, arg1) -> Float.valueOf(arg0.floatValue() - arg1.floatValue());

    ArithmeticOperatorsFactory() {
    }

    static BiFunction getAddFunction(DataType<?> fstArgDataType, DataType<?> sndArgDataType) {
        switch (fstArgDataType.id()) {
            case 10: 
            case 11: 
            case 15: {
                if (17 == sndArgDataType.id()) {
                    Signature signature = IntervalTimestampArithmeticScalar.signatureFor(fstArgDataType, "add");
                    return new IntervalTimestampArithmeticScalar("+", signature, signature);
                }
                return ADD_LONG_FUNCTION;
            }
            case 6: {
                return ADD_DOUBLE_FUNCTION;
            }
            case 7: {
                return ADD_FLOAT_FUNCTION;
            }
            case 2: 
            case 8: 
            case 9: {
                return ADD_INTEGER_FUNCTION;
            }
        }
        throw new UnsupportedOperationException("Cannot create add function for data type " + fstArgDataType.getName());
    }

    static BiFunction getSubtractFunction(DataType<?> fstArgDataType, DataType<?> sndArgDataType) {
        switch (fstArgDataType.id()) {
            case 10: 
            case 11: 
            case 15: {
                if (17 == sndArgDataType.id()) {
                    Signature signature = IntervalTimestampArithmeticScalar.signatureFor(fstArgDataType, "subtract");
                    return new IntervalTimestampArithmeticScalar("-", signature, signature);
                }
                return SUB_LONG_FUNCTION;
            }
            case 6: {
                return SUB_DOUBLE_FUNCTION;
            }
            case 7: {
                return SUB_FLOAT_FUNCTION;
            }
            case 2: 
            case 8: 
            case 9: {
                return SUB_INTEGER_FUNCTION;
            }
        }
        throw new UnsupportedOperationException("Cannot create subtract function for data type " + fstArgDataType.getName());
    }
}

