/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.sort;

import io.crate.breaker.RowAccounting;
import io.crate.data.BatchIterator;
import io.crate.data.Bucket;
import io.crate.data.CollectingBatchIterator;
import io.crate.data.Input;
import io.crate.data.Projector;
import io.crate.data.Row;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.sort.BoundedSortingTopNCollector;
import io.crate.execution.engine.sort.UnboundedSortingTopNCollector;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collector;

public class SortingTopNProjector
implements Projector {
    private final Collector<Row, ?, Bucket> collector;

    public SortingTopNProjector(RowAccounting<Object[]> rowAccounting, Collection<? extends Input<?>> inputs, Iterable<? extends CollectExpression<Row, ?>> collectExpressions, int numOutputs, Comparator<Object[]> ordering, int limit, int offset, int unboundedCollectorThreshold) {
        this.collector = limit + offset > unboundedCollectorThreshold ? new UnboundedSortingTopNCollector(rowAccounting, inputs, collectExpressions, numOutputs, ordering, unboundedCollectorThreshold, limit, offset) : new BoundedSortingTopNCollector(rowAccounting, inputs, collectExpressions, numOutputs, ordering, limit, offset);
    }

    @Override
    public BatchIterator<Row> apply(BatchIterator<Row> batchIterator) {
        return CollectingBatchIterator.newInstance(batchIterator, this.collector);
    }

    @Override
    public boolean providesIndependentScroll() {
        return true;
    }
}

