/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.sort;

import io.crate.data.Input;
import io.crate.execution.engine.collect.DocInputFactory;
import io.crate.execution.engine.sort.InputFieldComparator;
import io.crate.execution.engine.sort.NullFieldComparatorSource;
import io.crate.expression.InputFactory;
import io.crate.expression.reference.doc.lucene.CollectorContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.reference.doc.lucene.NullSentinelValues;
import io.crate.expression.symbol.AliasSymbol;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.Symbols;
import io.crate.lucene.FieldTypeLookup;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocSysColumns;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.search.SortedSetSortField;
import org.elasticsearch.index.fielddata.NullValueOrder;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.search.MultiValueMode;

public class SortSymbolVisitor
extends SymbolVisitor<SortSymbolContext, SortField> {
    private static final SortField SORT_SCORE_REVERSE = new SortField(null, SortField.Type.SCORE, true);
    private static final SortField SORT_SCORE = new SortField(null, SortField.Type.SCORE);
    private final DocInputFactory docInputFactory;
    private final FieldTypeLookup fieldTypeLookup;

    SortSymbolVisitor(DocInputFactory docInputFactory, FieldTypeLookup fieldTypeLookup) {
        this.docInputFactory = docInputFactory;
        this.fieldTypeLookup = fieldTypeLookup;
    }

    SortField[] generateSortFields(List<Symbol> sortSymbols, TransactionContext txnCtx, CollectorContext collectorContext, boolean[] reverseFlags, boolean[] nullsFirst) {
        SortField[] sortFields = new SortField[sortSymbols.size()];
        for (int i = 0; i < sortSymbols.size(); ++i) {
            Symbol sortSymbol = sortSymbols.get(i);
            sortFields[i] = sortSymbol.accept(this, new SortSymbolContext(txnCtx, collectorContext, reverseFlags[i], nullsFirst[i]));
        }
        return sortFields;
    }

    @Override
    public SortField visitReference(Reference symbol, SortSymbolContext context) {
        ColumnIdent columnIdent = symbol.column();
        if (DocSysColumns.SCORE.equals(columnIdent)) {
            return !context.reverseFlag ? SORT_SCORE_REVERSE : SORT_SCORE;
        }
        if (DocSysColumns.RAW.equals(columnIdent) || DocSysColumns.ID.equals(columnIdent)) {
            return this.customSortField(DocSysColumns.nameForLucene(columnIdent), symbol, context);
        }
        if (symbol.isColumnStoreDisabled()) {
            return this.customSortField(symbol.toString(), symbol, context);
        }
        MappedFieldType fieldType = this.fieldTypeLookup.get(columnIdent.fqn());
        if (fieldType == null) {
            NullFieldComparatorSource fieldComparatorSource = new NullFieldComparatorSource(NullSentinelValues.nullSentinelForScoreDoc(symbol.valueType(), context.reverseFlag, context.nullFirst));
            return new SortField(columnIdent.fqn(), (FieldComparatorSource)fieldComparatorSource, context.reverseFlag);
        }
        if (symbol.valueType().equals(DataTypes.IP)) {
            return this.customSortField(symbol.toString(), symbol, context);
        }
        return SortSymbolVisitor.mappedSortField(symbol, fieldType, context.reverseFlag, NullValueOrder.fromFlag(context.nullFirst));
    }

    private static SortField mappedSortField(Reference symbol, MappedFieldType fieldType, boolean reverse, NullValueOrder nullValueOrder) {
        String fieldName = symbol.column().fqn();
        MultiValueMode sortMode = reverse ? MultiValueMode.MAX : MultiValueMode.MIN;
        switch (symbol.valueType().id()) {
            case 4: {
                SortedSetSortField sortField = new SortedSetSortField(fieldName, reverse, sortMode == MultiValueMode.MAX ? SortedSetSelector.Type.MAX : SortedSetSelector.Type.MIN);
                sortField.setMissingValue(nullValueOrder == NullValueOrder.LAST ^ reverse ? SortedSetSortField.STRING_LAST : SortedSetSortField.STRING_FIRST);
                return sortField;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                SortedNumericSelector.Type selectorType = sortMode == MultiValueMode.MAX ? SortedNumericSelector.Type.MAX : SortedNumericSelector.Type.MIN;
                SortField.Type reducedType = SortField.Type.LONG;
                SortedNumericSortField sortField = new SortedNumericSortField(fieldName, SortField.Type.LONG, reverse, selectorType);
                sortField.setMissingValue(NullSentinelValues.nullSentinelForReducedType(reducedType, nullValueOrder, reverse));
                return sortField;
            }
            case 7: {
                SortedNumericSelector.Type selectorType = sortMode == MultiValueMode.MAX ? SortedNumericSelector.Type.MAX : SortedNumericSelector.Type.MIN;
                SortField.Type reducedType = SortField.Type.FLOAT;
                SortedNumericSortField sortField = new SortedNumericSortField(fieldName, SortField.Type.FLOAT, reverse, selectorType);
                sortField.setMissingValue(NullSentinelValues.nullSentinelForReducedType(reducedType, nullValueOrder, reverse));
                return sortField;
            }
            case 6: {
                SortedNumericSelector.Type selectorType = sortMode == MultiValueMode.MAX ? SortedNumericSelector.Type.MAX : SortedNumericSelector.Type.MIN;
                SortField.Type reducedType = SortField.Type.DOUBLE;
                SortedNumericSortField sortField = new SortedNumericSortField(fieldName, SortField.Type.DOUBLE, reverse, selectorType);
                sortField.setMissingValue(NullSentinelValues.nullSentinelForReducedType(reducedType, nullValueOrder, reverse));
                return sortField;
            }
            case 13: {
                throw new IllegalArgumentException("can't sort on geo_point field without using specific sorting feature, like geo_distance");
            }
        }
        throw new UnsupportedOperationException("Cannot order on " + symbol + "::" + symbol.valueType());
    }

    @Override
    public SortField visitFunction(Function function, SortSymbolContext context) {
        return this.customSortField(function.toString(), function, context);
    }

    @Override
    public SortField visitAlias(AliasSymbol aliasSymbol, SortSymbolContext context) {
        return aliasSymbol.symbol().accept(this, context);
    }

    @Override
    protected SortField visitSymbol(Symbol symbol, SortSymbolContext context) {
        throw new UnsupportedOperationException(Symbols.format("Using a non-integer constant in ORDER BY is not supported", symbol));
    }

    private SortField customSortField(String name, final Symbol symbol, SortSymbolContext context) {
        InputFactory.Context<LuceneCollectorExpression<?>> inputContext = this.docInputFactory.getCtx(context.txnCtx);
        final Input<?> input = inputContext.add(symbol);
        final List<? extends LuceneCollectorExpression<?>> expressions = inputContext.expressions();
        final CollectorContext collectorContext = context.context;
        final boolean nullFirst = context.nullFirst;
        return new SortField(name, new FieldComparatorSource(){

            public FieldComparator<?> newComparator(String fieldName, int numHits, int sortPos, boolean reversed) {
                for (int i = 0; i < expressions.size(); ++i) {
                    ((LuceneCollectorExpression)expressions.get(i)).startCollect(collectorContext);
                }
                DataType<Object> dataType = symbol.valueType();
                Object nullSentinel = NullSentinelValues.nullSentinel(dataType, NullValueOrder.fromFlag(nullFirst), reversed);
                return new InputFieldComparator(numHits, expressions, input, nullSentinel == null ? (nullFirst ^ reversed ? Comparator.nullsFirst(dataType) : Comparator.nullsLast(dataType)) : dataType, nullSentinel);
            }
        }, context.reverseFlag);
    }

    static class SortSymbolContext {
        private final boolean reverseFlag;
        private final CollectorContext context;
        private final TransactionContext txnCtx;
        private final boolean nullFirst;

        SortSymbolContext(TransactionContext txnCtx, CollectorContext collectorContext, boolean reverseFlag, boolean nullFirst) {
            this.txnCtx = txnCtx;
            this.nullFirst = nullFirst;
            this.context = collectorContext;
            this.reverseFlag = reverseFlag;
        }
    }
}

