/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.sort;

import com.google.common.collect.Ordering;
import io.crate.analyze.OrderBy;
import io.crate.data.Row;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.engine.sort.NullAwareComparator;
import io.crate.planner.PositionalOrderBy;
import io.crate.planner.consumer.OrderByPositionVisitor;
import java.util.ArrayList;
import java.util.Comparator;

public final class OrderingByPosition {
    public static Comparator<Object[]> arrayOrdering(RoutedCollectPhase collectPhase) {
        OrderBy orderBy = collectPhase.orderBy();
        assert (orderBy != null) : "collectPhase must have an orderBy clause to generate an ordering";
        return OrderingByPosition.arrayOrdering(OrderByPositionVisitor.orderByPositions(orderBy.orderBySymbols(), collectPhase.toCollect()), orderBy.reverseFlags(), orderBy.nullsFirst());
    }

    public static Ordering<Row> rowOrdering(PositionalOrderBy orderBy) {
        return OrderingByPosition.rowOrdering(orderBy.indices(), orderBy.reverseFlags(), orderBy.nullsFirst());
    }

    public static Ordering<Row> rowOrdering(int[] positions, boolean[] reverseFlags, boolean[] nullsFirst) {
        ArrayList<Comparator<Row>> comparators = new ArrayList<Comparator<Row>>(positions.length);
        for (int i = 0; i < positions.length; ++i) {
            Comparator<Row> rowOrdering = OrderingByPosition.rowOrdering(positions[i], reverseFlags[i], nullsFirst[i]);
            comparators.add(rowOrdering);
        }
        return Ordering.compound(comparators);
    }

    public static Comparator<Row> rowOrdering(int position, boolean reverse, boolean nullsFirst) {
        return new NullAwareComparator<Row>(row -> (Comparable)row.get(position), reverse, nullsFirst);
    }

    public static Comparator<Object[]> arrayOrdering(int[] position, boolean[] reverse, boolean[] nullsFirst) {
        if (position.length == 1) {
            return OrderingByPosition.arrayOrdering(position[0], reverse[0], nullsFirst[0]);
        }
        ArrayList<Comparator<Object[]>> comparators = new ArrayList<Comparator<Object[]>>(position.length);
        int positionLength = position.length;
        for (int i = 0; i < positionLength; ++i) {
            comparators.add(OrderingByPosition.arrayOrdering(position[i], reverse[i], nullsFirst[i]));
        }
        return Ordering.compound(comparators);
    }

    public static Comparator<Object[]> arrayOrdering(int position, boolean reverse, boolean nullsFirst) {
        return new NullAwareComparator<Object[]>(cells -> (Comparable)cells[position], reverse, nullsFirst);
    }
}

