/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.sort;

import java.util.Comparator;
import java.util.function.Function;

class NullAwareComparator<T>
implements Comparator<T> {
    private final int mod;
    private final Function<T, Comparable<Object>> keyExtractor;
    private final int leftNull;
    private final int rightNull;

    NullAwareComparator(Function<T, Comparable<Object>> keyExtractor, boolean reverse, boolean nullsFirst) {
        this.keyExtractor = keyExtractor;
        this.mod = reverse ? -1 : 1;
        this.leftNull = nullsFirst ? -1 : 1;
        this.rightNull = nullsFirst ? 1 : -1;
    }

    @Override
    public int compare(T o1, T o2) {
        Comparable<Object> val2;
        Comparable<Object> val1 = this.keyExtractor.apply(o1);
        if (val1 == (val2 = this.keyExtractor.apply(o2))) {
            return 0;
        }
        if (val1 == null) {
            return this.leftNull;
        }
        if (val2 == null) {
            return this.rightNull;
        }
        int cmp = val1.compareTo(val2);
        return cmp * this.mod;
    }
}

