/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.sort;

import io.crate.data.Input;
import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Scorable;

class InputFieldComparator
extends FieldComparator<Object>
implements LeafFieldComparator {
    private final Object[] values;
    private final Input<?> input;
    private final List<? extends LuceneCollectorExpression<?>> collectorExpressions;
    private final Comparator<Object> comparator;
    @Nullable
    private final Object missingValue;
    private Object bottom;
    private Object top;

    InputFieldComparator(int numHits, List<? extends LuceneCollectorExpression<?>> collectorExpressions, Input<?> input, Comparator<Object> comparator, @Nullable Object missingValue) {
        this.collectorExpressions = collectorExpressions;
        this.comparator = comparator;
        this.missingValue = missingValue;
        this.values = new Object[numHits];
        this.input = input;
    }

    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        for (int i = 0; i < this.collectorExpressions.size(); ++i) {
            this.collectorExpressions.get(i).setNextReader(new ReaderContext(context));
        }
        return this;
    }

    public int compare(int slot1, int slot2) {
        return this.comparator.compare(this.values[slot1], this.values[slot2]);
    }

    public void setBottom(int slot) {
        this.bottom = this.values[slot];
    }

    public void setTopValue(Object value) {
        this.top = value;
    }

    public int compareBottom(int doc) throws IOException {
        for (int i = 0; i < this.collectorExpressions.size(); ++i) {
            this.collectorExpressions.get(i).setNextDocId(doc);
        }
        return this.comparator.compare(this.bottom, InputFieldComparator.getFirstNonNullOrNull(this.input.value(), this.missingValue));
    }

    @Nullable
    private static Object getFirstNonNullOrNull(Object first, Object second) {
        if (first != null) {
            return first;
        }
        return second;
    }

    public int compareTop(int doc) throws IOException {
        for (int i = 0; i < this.collectorExpressions.size(); ++i) {
            this.collectorExpressions.get(i).setNextDocId(doc);
        }
        return this.comparator.compare(this.top, InputFieldComparator.getFirstNonNullOrNull(this.input.value(), this.missingValue));
    }

    public void copy(int slot, int doc) throws IOException {
        for (int i = 0; i < this.collectorExpressions.size(); ++i) {
            this.collectorExpressions.get(i).setNextDocId(doc);
        }
        Object value = this.input.value();
        this.values[slot] = value == null ? this.missingValue : value;
    }

    public void setScorer(Scorable scorer) {
    }

    public Object value(int slot) {
        return this.values[slot];
    }
}

