/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.sort;

import com.google.common.collect.Ordering;
import io.crate.analyze.OrderBy;
import io.crate.data.ArrayRow;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.sort.NullAwareComparator;
import io.crate.execution.engine.sort.OrderingByPosition;
import io.crate.expression.ExpressionsInput;
import io.crate.expression.InputFactory;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Symbol;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class Comparators {
    @Nullable
    public static <T extends CollectExpression<Row, ?>> Comparator<Object[]> createComparator(Supplier<InputFactory.Context<T>> createInputFactoryCtx, @Nullable OrderBy orderBy) {
        if (orderBy == null) {
            return null;
        }
        List<Symbol> orderBySymbols = orderBy.orderBySymbols();
        int[] positions = new int[orderBySymbols.size()];
        for (int i = 0; i < orderBySymbols.size(); ++i) {
            Symbol symbol = orderBySymbols.get(i);
            if (!(symbol instanceof InputColumn)) {
                return Comparators.createComparatorWithEval(createInputFactoryCtx, orderBy);
            }
            positions[i] = ((InputColumn)symbol).index();
        }
        return OrderingByPosition.arrayOrdering(positions, orderBy.reverseFlags(), orderBy.nullsFirst());
    }

    private static <T extends CollectExpression<Row, ?>> Comparator<Object[]> createComparatorWithEval(Supplier<InputFactory.Context<T>> createInputFactoryCtx, OrderBy orderBy) {
        List<Symbol> orderBySymbols = orderBy.orderBySymbols();
        ArrayList<NullAwareComparator<Object[]>> comparators = new ArrayList<NullAwareComparator<Object[]>>(orderBySymbols.size());
        for (int i = 0; i < orderBySymbols.size(); ++i) {
            Symbol orderSymbol = orderBySymbols.get(i);
            InputFactory.Context<T> ctx = createInputFactoryCtx.get();
            Input<?> input = ctx.add(orderSymbol);
            ExpressionsInput expressionsInput = new ExpressionsInput(input, ctx.expressions());
            ArrayRow row = new ArrayRow();
            comparators.add(new NullAwareComparator<Object[]>(cells -> {
                Comparable value;
                ArrayRow arrayRow = row;
                synchronized (arrayRow) {
                    row.cells((Object[])cells);
                    value = (Comparable)expressionsInput.value(row);
                }
                return value;
            }, orderBy.reverseFlags()[i], orderBy.nullsFirst()[i]));
        }
        return Ordering.compound(comparators);
    }
}

