/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.profile;

import io.crate.action.FutureActionListener;
import io.crate.execution.engine.profile.NodeCollectProfileRequest;
import io.crate.execution.engine.profile.NodeCollectProfileResponse;
import io.crate.execution.jobs.RootTask;
import io.crate.execution.jobs.TasksService;
import io.crate.execution.support.NodeAction;
import io.crate.execution.support.NodeActionRequestHandler;
import io.crate.execution.support.Transports;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportCollectProfileNodeAction
implements NodeAction<NodeCollectProfileRequest, NodeCollectProfileResponse> {
    private static final String TRANSPORT_ACTION = "internal:crate:sql/node/profile/collect";
    private static final String EXECUTOR = "search";
    private final Transports transports;
    private final TasksService tasksService;

    @Inject
    public TransportCollectProfileNodeAction(TransportService transportService, Transports transports, TasksService tasksService) {
        this.transports = transports;
        this.tasksService = tasksService;
        transportService.registerRequestHandler(TRANSPORT_ACTION, EXECUTOR, true, false, NodeCollectProfileRequest::new, new NodeActionRequestHandler<NodeCollectProfileRequest, NodeCollectProfileResponse>(this));
    }

    @Override
    public CompletableFuture<NodeCollectProfileResponse> nodeOperation(NodeCollectProfileRequest request) {
        return this.collectExecutionTimesAndFinishContext(request.jobId()).thenApply(NodeCollectProfileResponse::new);
    }

    public CompletableFuture<Map<String, Object>> collectExecutionTimesAndFinishContext(UUID jobId) {
        RootTask rootTask = this.tasksService.getTaskOrNull(jobId);
        if (rootTask == null) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        return rootTask.finishProfiling();
    }

    public void execute(String nodeId, NodeCollectProfileRequest request, FutureActionListener<NodeCollectProfileResponse, Map<String, Object>> listener) {
        this.transports.sendRequest(TRANSPORT_ACTION, nodeId, request, listener, new ActionListenerResponseHandler<NodeCollectProfileResponse>(listener, NodeCollectProfileResponse::new));
    }
}

