/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.pipeline;

import io.crate.breaker.RowAccounting;
import io.crate.data.BatchIterator;
import io.crate.data.Projector;
import io.crate.data.Row;
import io.crate.data.RowN;
import io.crate.data.TopNDistinctBatchIterator;

public final class TopNDistinctProjector
implements Projector {
    private final int limit;
    private final RowAccounting<Object[]> rowAccounting;

    TopNDistinctProjector(int limit, RowAccounting<Object[]> rowAccounting) {
        this.limit = limit;
        this.rowAccounting = rowAccounting;
    }

    @Override
    public BatchIterator<Row> apply(BatchIterator<Row> source) {
        return new TopNDistinctBatchIterator<Row>(source, this.limit, row -> {
            Object[] cells = row.materialize();
            this.rowAccounting.accountForAndMaybeBreak(cells);
            return new RowN(cells);
        });
    }

    @Override
    public boolean providesIndependentScroll() {
        return false;
    }
}

