/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.pipeline;

import io.crate.exceptions.RelationUnknown;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;

public final class TableSettingsResolver {
    public static Settings get(Metadata metadata, RelationName relationName, boolean partitioned) {
        if (partitioned) {
            return TableSettingsResolver.forPartitionedTable(metadata, relationName);
        }
        return TableSettingsResolver.forTable(metadata, relationName);
    }

    private static Settings forTable(Metadata metadata, RelationName relationName) {
        IndexMetadata indexMetadata = metadata.index(relationName.indexNameOrAlias());
        if (indexMetadata == null) {
            throw new IndexNotFoundException(relationName.indexNameOrAlias());
        }
        return indexMetadata.getSettings();
    }

    private static Settings forPartitionedTable(Metadata metadata, RelationName relationName) {
        String templateName = PartitionName.templateName(relationName.schema(), relationName.name());
        IndexTemplateMetadata templateMetadata = metadata.templates().get(templateName);
        if (templateMetadata == null) {
            throw new RelationUnknown(relationName);
        }
        return templateMetadata.getSettings();
    }

    private TableSettingsResolver() {
    }
}

