/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.pipeline;

import io.crate.breaker.RamAccounting;
import io.crate.data.BatchIterator;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.engine.pipeline.ProjectorFactory;
import io.crate.execution.engine.pipeline.Projectors;
import io.crate.memory.MemoryManager;
import io.crate.metadata.TransactionContext;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public class ProjectingRowConsumer
implements RowConsumer {
    private final RowConsumer consumer;
    private final Projectors projectors;

    public static RowConsumer create(RowConsumer lastConsumer, Collection<? extends Projection> projections, UUID jobId, TransactionContext txnCtx, RamAccounting ramAccounting, MemoryManager memoryManager, ProjectorFactory projectorFactory) {
        if (projections.isEmpty()) {
            return lastConsumer;
        }
        return new ProjectingRowConsumer(lastConsumer, projections, jobId, txnCtx, ramAccounting, memoryManager, projectorFactory);
    }

    private ProjectingRowConsumer(RowConsumer consumer, Collection<? extends Projection> projections, UUID jobId, TransactionContext txnCtx, RamAccounting ramAccounting, MemoryManager memoryManager, ProjectorFactory projectorFactory) {
        this.consumer = consumer;
        this.projectors = new Projectors(projections, jobId, txnCtx, ramAccounting, memoryManager, projectorFactory);
    }

    @Override
    public void accept(BatchIterator<Row> iterator, @Nullable Throwable failure) {
        if (failure == null) {
            try {
                iterator = this.projectors.wrap(iterator);
            }
            catch (Throwable t) {
                this.consumer.accept(null, t);
                return;
            }
            this.consumer.accept(iterator, null);
        } else {
            this.consumer.accept(iterator, failure);
        }
    }

    @Override
    public CompletableFuture<?> completionFuture() {
        return this.consumer.completionFuture();
    }

    @Override
    public boolean requiresScroll() {
        return this.consumer.requiresScroll() && !this.projectors.providesIndependentScroll();
    }
}

