/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.join;

import java.util.function.IntSupplier;
import org.elasticsearch.common.breaker.CircuitBreaker;

public class RamBlockSizeCalculator
implements IntSupplier {
    public static final int FALLBACK_SIZE = 500;
    private final int defaultBlockSize;
    private final CircuitBreaker circuitBreaker;
    private final long estimatedRowSizeForLeft;
    private final long numberOfRowsForLeft;

    public RamBlockSizeCalculator(int defaultBlockSize, CircuitBreaker circuitBreaker, long estimatedRowSizeForLeft, long numberOfRowsForLeft) {
        this.defaultBlockSize = defaultBlockSize;
        this.circuitBreaker = circuitBreaker;
        this.estimatedRowSizeForLeft = estimatedRowSizeForLeft;
        this.numberOfRowsForLeft = numberOfRowsForLeft;
    }

    @Override
    public int getAsInt() {
        if (RamBlockSizeCalculator.statisticsUnavailable(this.circuitBreaker, this.estimatedRowSizeForLeft, this.numberOfRowsForLeft)) {
            return 500;
        }
        long availableMemory = this.circuitBreaker.getLimit() - this.circuitBreaker.getUsed();
        long numRowsFittingIntoAvailableMemory = availableMemory / this.estimatedRowSizeForLeft;
        int cap = (int)Math.min(this.numberOfRowsForLeft, (long)this.defaultBlockSize);
        int blockSize = (int)Math.min((long)cap, numRowsFittingIntoAvailableMemory);
        return blockSize <= 0 ? 10 : blockSize;
    }

    private static boolean statisticsUnavailable(CircuitBreaker circuitBreaker, long estimatedRowSizeForLeft, long numberOfRowsForLeft) {
        return estimatedRowSizeForLeft <= 0L || numberOfRowsForLeft <= 0L || circuitBreaker.getLimit() == -1L;
    }
}

