/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.join;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import io.crate.analyze.relations.JoinPair;
import io.crate.execution.dsl.phases.MergePhase;
import io.crate.execution.dsl.projection.EvalProjection;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.builder.InputColumns;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.operator.AndOperator;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RelationName;
import io.crate.planner.PlannerContext;
import io.crate.planner.ResultDescription;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.planner.node.dql.join.JoinType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class JoinOperations {
    private JoinOperations() {
    }

    public static boolean isMergePhaseNeeded(Collection<String> executionNodes, ResultDescription resultDescription, boolean isDistributed) {
        return isDistributed || resultDescription.hasRemainingLimitOrOffset() || !resultDescription.nodeIds().equals(executionNodes);
    }

    public static MergePhase buildMergePhaseForJoin(PlannerContext plannerContext, ResultDescription resultDescription, Collection<String> executionNodes) {
        List<Projection> projections = Collections.emptyList();
        if (resultDescription.hasRemainingLimitOrOffset()) {
            projections = Collections.singletonList(ProjectionBuilder.topNOrEvalIfNeeded(resultDescription.limit(), resultDescription.offset(), resultDescription.numOutputs(), resultDescription.streamOutputs()));
        }
        return new MergePhase(plannerContext.jobId(), plannerContext.nextExecutionPhaseId(), "join-merge", resultDescription.nodeIds().size(), 1, executionNodes, resultDescription.streamOutputs(), projections, DistributionInfo.DEFAULT_SAME_NODE, resultDescription.orderBy());
    }

    public static Projection createJoinProjection(List<Symbol> outputs, List<Symbol> joinOutputs) {
        List<Symbol> projectionOutputs = InputColumns.create(outputs, new InputColumns.SourceSymbols(joinOutputs));
        return new EvalProjection(projectionOutputs);
    }

    public static LinkedHashMap<Set<RelationName>, JoinPair> buildRelationsToJoinPairsMap(List<JoinPair> joinPairs) {
        LinkedHashMap<Set<RelationName>, JoinPair> joinPairsMap = new LinkedHashMap<Set<RelationName>, JoinPair>();
        for (JoinPair joinPair : joinPairs) {
            if (joinPair.condition() == null) continue;
            JoinPair prevPair = joinPairsMap.put(Sets.newHashSet((Object[])new RelationName[]{joinPair.left(), joinPair.right()}), joinPair);
            if (prevPair == null) continue;
            throw new IllegalStateException("joinPairs contains duplicate: " + joinPair + " matches " + prevPair);
        }
        return joinPairsMap;
    }

    public static List<JoinPair> convertImplicitJoinConditionsToJoinPairs(List<JoinPair> explicitJoinPairs, Map<Set<RelationName>, Symbol> splitQueries) {
        Iterator<Map.Entry<Set<RelationName>, Symbol>> queryIterator = splitQueries.entrySet().iterator();
        ArrayList<JoinPair> newJoinPairs = new ArrayList<JoinPair>(explicitJoinPairs.size() + splitQueries.size());
        newJoinPairs.addAll(explicitJoinPairs);
        while (queryIterator.hasNext()) {
            Map.Entry<Set<RelationName>, Symbol> queryEntry = queryIterator.next();
            Set<RelationName> relations = queryEntry.getKey();
            if (relations.size() != 2) continue;
            Symbol implicitJoinCondition = queryEntry.getValue();
            JoinPair newJoinPair = null;
            int existingJoinPairIdx = -1;
            for (int i = 0; i < explicitJoinPairs.size(); ++i) {
                JoinPair joinPair = explicitJoinPairs.get(i);
                if (!relations.contains(joinPair.left()) || !relations.contains(joinPair.right())) continue;
                existingJoinPairIdx = i;
                if (joinPair.joinType() == JoinType.INNER || joinPair.joinType() == JoinType.CROSS) {
                    newJoinPair = JoinPair.of(joinPair.left(), joinPair.right(), JoinType.INNER, JoinOperations.mergeJoinConditions(joinPair.condition(), implicitJoinCondition));
                    queryIterator.remove();
                    continue;
                }
                newJoinPair = joinPair;
            }
            if (newJoinPair == null) {
                Iterator<RelationName> namesIter = relations.iterator();
                newJoinPair = JoinPair.of(namesIter.next(), namesIter.next(), JoinType.INNER, implicitJoinCondition);
                queryIterator.remove();
                newJoinPairs.add(newJoinPair);
                continue;
            }
            newJoinPairs.set(existingJoinPairIdx, newJoinPair);
        }
        return newJoinPairs;
    }

    private static Symbol mergeJoinConditions(@Nullable Symbol condition1, Symbol condition2) {
        if (condition1 == null) {
            return condition2;
        }
        return AndOperator.join((Iterable<? extends Symbol>)ImmutableList.of((Object)condition1, (Object)condition2));
    }
}

