/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.join;

import io.crate.breaker.RowAccounting;
import io.crate.data.BatchIterator;
import io.crate.data.Paging;
import io.crate.data.Row;
import io.crate.data.UnsafeArrayRow;
import io.crate.data.join.CombinedRow;
import io.crate.data.join.JoinBatchIterator;
import io.netty.util.collection.IntObjectHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;

public class HashInnerJoinBatchIterator
extends JoinBatchIterator<Row, Row, Row> {
    private final RowAccounting<Object[]> leftRowAccounting;
    private final Predicate<Row> joinCondition;
    private final UnsafeArrayRow leftRow = new UnsafeArrayRow();
    private final ToIntFunction<Row> hashBuilderForLeft;
    private final ToIntFunction<Row> hashBuilderForRight;
    private final IntSupplier calculateBlockSize;
    private final IntObjectHashMap<List<Object[]>> buffer;
    private final UnsafeArrayRow unsafeArrayRow = new UnsafeArrayRow();
    private int blockSize;
    private int numberOfRowsInBuffer = 0;
    private boolean leftBatchHasItems = false;
    private int numberOfLeftBatchesForBlock;
    private int numberOfLeftBatchesLoadedForBlock;
    private Iterator<Object[]> leftMatchingRowsIterator;

    public HashInnerJoinBatchIterator(BatchIterator<Row> left, BatchIterator<Row> right, RowAccounting<Object[]> leftRowAccounting, CombinedRow combiner, Predicate<Row> joinCondition, ToIntFunction<Row> hashBuilderForLeft, ToIntFunction<Row> hashBuilderForRight, IntSupplier calculateBlockSize) {
        super(left, right, combiner);
        this.leftRowAccounting = leftRowAccounting;
        this.joinCondition = joinCondition;
        this.hashBuilderForLeft = hashBuilderForLeft;
        this.hashBuilderForRight = hashBuilderForRight;
        this.calculateBlockSize = calculateBlockSize;
        this.buffer = new IntObjectHashMap();
        this.resetBuffer();
        this.numberOfLeftBatchesLoadedForBlock = 1;
        this.activeIt = left;
    }

    @Override
    public Row currentElement() {
        return (Row)this.combiner.currentElement();
    }

    @Override
    public void moveToStart() {
        this.left.moveToStart();
        this.right.moveToStart();
        this.activeIt = this.left;
        this.resetBuffer();
        this.leftMatchingRowsIterator = null;
    }

    @Override
    public CompletionStage<?> loadNextBatch() throws Exception {
        if (this.activeIt == this.left) {
            ++this.numberOfLeftBatchesLoadedForBlock;
        }
        return super.loadNextBatch();
    }

    @Override
    public boolean moveNext() {
        while (!this.buildBufferAndMatchRight()) {
            if (this.right.allLoaded() && !this.leftBatchHasItems && this.left.allLoaded()) {
                return false;
            }
            if (this.activeIt == this.left) {
                return false;
            }
            if (this.right.allLoaded()) {
                this.right.moveToStart();
                this.activeIt = this.left;
                this.resetBuffer();
                continue;
            }
            return false;
        }
        return true;
    }

    private void resetBuffer() {
        this.blockSize = this.calculateBlockSize.getAsInt();
        this.buffer.clear();
        this.numberOfRowsInBuffer = 0;
        this.leftRowAccounting.release();
        this.numberOfLeftBatchesForBlock = Math.max(1, (int)Math.ceil((double)this.blockSize / (double)Paging.PAGE_SIZE));
        this.numberOfLeftBatchesLoadedForBlock = this.leftBatchHasItems ? 1 : 0;
    }

    private boolean buildBufferAndMatchRight() {
        if (this.activeIt == this.left) {
            while (this.leftBatchHasItems = this.left.moveNext()) {
                Object[] leftRow = ((Row)this.left.currentElement()).materialize();
                this.leftRowAccounting.accountForAndMaybeBreak(leftRow);
                int hash = this.hashBuilderForLeft.applyAsInt(this.unsafeArrayRow.cells(leftRow));
                this.addToBuffer(leftRow, hash);
                if (this.numberOfRowsInBuffer != this.blockSize) continue;
                break;
            }
            if (this.mustLoadLeftNextBatch()) {
                return false;
            }
            if (this.mustSwitchToRight()) {
                this.activeIt = this.right;
            }
        }
        if (this.leftMatchingRowsIterator != null && this.findMatchingRows()) {
            return true;
        }
        this.leftMatchingRowsIterator = null;
        while (this.right.moveNext()) {
            int rightHash = this.hashBuilderForRight.applyAsInt((Row)this.right.currentElement());
            List leftMatchingRows = (List)this.buffer.get(rightHash);
            if (leftMatchingRows == null) continue;
            this.leftMatchingRowsIterator = leftMatchingRows.iterator();
            this.combiner.setRight((Row)this.right.currentElement());
            if (!this.findMatchingRows()) continue;
            return true;
        }
        return false;
    }

    private void addToBuffer(Object[] currentRow, int hash) {
        ArrayList<Object[]> existingRows = (ArrayList<Object[]>)this.buffer.get(hash);
        if (existingRows == null) {
            existingRows = new ArrayList<Object[]>();
            this.buffer.put(hash, existingRows);
        }
        existingRows.add(currentRow);
        ++this.numberOfRowsInBuffer;
    }

    private boolean findMatchingRows() {
        while (this.leftMatchingRowsIterator.hasNext()) {
            this.leftRow.cells(this.leftMatchingRowsIterator.next());
            this.combiner.setLeft(this.leftRow);
            if (!this.joinCondition.test((Row)this.combiner.currentElement())) continue;
            return true;
        }
        return false;
    }

    private boolean mustSwitchToRight() {
        return this.left.allLoaded() || this.numberOfRowsInBuffer == this.blockSize || !this.leftBatchHasItems && this.numberOfLeftBatchesLoadedForBlock == this.numberOfLeftBatchesForBlock;
    }

    private boolean mustLoadLeftNextBatch() {
        return !this.leftBatchHasItems && !this.left.allLoaded() && this.numberOfRowsInBuffer < this.blockSize && this.numberOfLeftBatchesLoadedForBlock < this.numberOfLeftBatchesForBlock;
    }
}

