/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.indexing;

import io.crate.data.Row;
import io.crate.data.RowN;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;

class UpsertResults {
    private final Map<String, Result> resultsByUri = new HashMap<String, Result>(1);
    private final Map<String, String> nodeInfo;

    UpsertResults() {
        this.nodeInfo = null;
    }

    UpsertResults(Map<String, String> nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    void addResult(long successRowCount) {
        Result result = this.getResultSafe(null);
        result.successRowCount += successRowCount;
    }

    void addResultRows(List<Object[]> resultRows) {
        Result result = this.getResultSafe(null);
        result.resultRows.addAll(resultRows);
    }

    void addResult(String uri, @Nullable String failureMessage, long lineNumber) {
        Result result = this.getResultSafe(uri);
        if (failureMessage == null) {
            ++result.successRowCount;
        } else {
            ++result.errorRowCount;
            result.updateErrorCount(failureMessage, Collections.singletonList(lineNumber), 1L);
        }
    }

    void addUriFailure(String uri, String uriFailure) {
        assert (uri != null) : "expecting URI argument not to be null";
        Result result = this.getResultSafe(uri);
        result.sourceUriFailure = true;
        result.updateErrorCount(uriFailure, Collections.emptyList(), 1L);
    }

    private Result getResultSafe(@Nullable String uri) {
        Result result = this.resultsByUri.get(uri);
        if (result == null) {
            result = new Result();
            this.resultsByUri.put(uri, result);
        }
        return result;
    }

    long getSuccessRowCountForNoUri() {
        return this.getResultSafe(null).successRowCount;
    }

    List<Object[]> getResultRowsForNoUri() {
        return this.getResultSafe(null).resultRows;
    }

    void merge(UpsertResults other) {
        for (Map.Entry<String, Result> entry : other.resultsByUri.entrySet()) {
            Result result = this.resultsByUri.get(entry.getKey());
            if (result == null) {
                this.resultsByUri.put(entry.getKey(), entry.getValue());
                continue;
            }
            result.merge(entry.getValue());
        }
    }

    Iterable<Row> rowsIterable() {
        Stream<Row> s = this.resultsByUri.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> {
            Result r = (Result)e.getValue();
            if (r.sourceUriFailure) {
                return new RowN(this.nodeInfo, e.getKey(), null, null, r.errors);
            }
            return new RowN(this.nodeInfo, e.getKey(), r.successRowCount, r.errorRowCount, r.errors);
        });
        return s::iterator;
    }

    static class Result {
        private static final String ERROR_COUNT_KEY = "count";
        private static final String LINE_NUMBERS_KEY = "line_numbers";
        private static final int MAX_LINE_NUMBERS_ALLOWED = 50;
        private long successRowCount = 0L;
        private long errorRowCount = 0L;
        private final Map<String, Map<String, Object>> errors = new HashMap<String, Map<String, Object>>();
        private boolean sourceUriFailure = false;
        private final List<Object[]> resultRows = new ArrayList<Object[]>();

        Result() {
        }

        void merge(Result upsertResult) {
            this.successRowCount += upsertResult.successRowCount;
            this.errorRowCount += upsertResult.errorRowCount;
            if (!this.sourceUriFailure) {
                this.sourceUriFailure = upsertResult.sourceUriFailure;
            }
            for (Map.Entry<String, Map<String, Object>> entry : upsertResult.errors.entrySet()) {
                Map<String, Object> val = entry.getValue();
                List lineNumbers = (List)val.get(LINE_NUMBERS_KEY);
                Long errorCnt = (Long)val.get(ERROR_COUNT_KEY);
                this.updateErrorCount(entry.getKey(), lineNumbers, errorCnt);
            }
            this.resultRows.addAll(upsertResult.resultRows);
        }

        private void updateErrorCount(String msg, List<Long> lineNumbers, Long increaseBy) {
            ArrayList<Long> currentLineNumbers;
            Map<String, Object> errorEntry = this.errors.get(msg);
            Long cnt = 0L;
            if (errorEntry == null) {
                errorEntry = new HashMap<String, Object>(1);
                this.errors.put(msg, errorEntry);
                int lineNumbersTopIndex = Math.min(lineNumbers.size(), 50);
                currentLineNumbers = new ArrayList<Long>(lineNumbers.subList(0, lineNumbersTopIndex));
            } else {
                cnt = (Long)errorEntry.get(ERROR_COUNT_KEY);
                currentLineNumbers = (ArrayList<Long>)errorEntry.get(LINE_NUMBERS_KEY);
                int allowedLineNumbersCount = 50 - currentLineNumbers.size();
                if (lineNumbers.size() <= allowedLineNumbersCount) {
                    currentLineNumbers.addAll(lineNumbers);
                }
            }
            errorEntry.put(ERROR_COUNT_KEY, cnt + increaseBy);
            errorEntry.put(LINE_NUMBERS_KEY, currentLineNumbers);
        }
    }
}

