/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.indexing;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.execution.dsl.projection.SourceIndexWriterReturnSummaryProjection;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.indexing.ShardedRequests;
import io.crate.execution.engine.indexing.UpsertResultCollector;
import io.crate.execution.engine.indexing.UpsertResultCollectors;
import io.crate.expression.InputFactory;
import io.crate.metadata.TransactionContext;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.elasticsearch.cluster.node.DiscoveryNode;

public class UpsertResultContext {
    private final Input<String> sourceUriInput;
    private final Input<String> sourceUriFailureInput;
    private final Input<Long> lineNumberInput;
    private final List<? extends CollectExpression<Row, ?>> sourceInfoExpressions;
    private final UpsertResultCollector resultCollector;

    public static UpsertResultContext forRowCount() {
        return new UpsertResultContext(() -> null, () -> null, () -> null, Collections.emptyList(), UpsertResultCollectors.newRowCountCollector()){

            @Override
            BiConsumer<ShardedRequests, String> getItemFailureRecorder() {
                return (s, f) -> {};
            }

            @Override
            Predicate<ShardedRequests> getHasSourceUriFailureChecker() {
                return ignored -> false;
            }
        };
    }

    public static UpsertResultContext forResultRows() {
        return new UpsertResultContext(() -> null, () -> null, () -> null, Collections.emptyList(), UpsertResultCollectors.newResultRowCollector()){

            @Override
            BiConsumer<ShardedRequests, String> getItemFailureRecorder() {
                return (s, f) -> {};
            }

            @Override
            Predicate<ShardedRequests> getHasSourceUriFailureChecker() {
                return ignored -> false;
            }
        };
    }

    public static UpsertResultContext forReturnSummary(TransactionContext txnCtx, SourceIndexWriterReturnSummaryProjection projection, DiscoveryNode discoveryNode, InputFactory inputFactory) {
        InputFactory.Context<CollectExpression<Row, ?>> ctxSourceInfo = inputFactory.ctxForInputColumns(txnCtx);
        Input<String> sourceUriInput = ctxSourceInfo.add(projection.sourceUri());
        Input<String> sourceUriFailureInput = ctxSourceInfo.add(projection.sourceUriFailure());
        Input<Long> lineNumberInput = ctxSourceInfo.add(projection.lineNumber());
        return new UpsertResultContext(sourceUriInput, sourceUriFailureInput, lineNumberInput, ctxSourceInfo.expressions(), UpsertResultCollectors.newSummaryCollector(discoveryNode));
    }

    private UpsertResultContext(Input<String> sourceUriInput, Input<String> sourceUriFailureInput, Input<Long> lineNumberInput, List<? extends CollectExpression<Row, ?>> sourceInfoExpressions, UpsertResultCollector resultCollector) {
        this.sourceUriInput = sourceUriInput;
        this.sourceUriFailureInput = sourceUriFailureInput;
        this.lineNumberInput = lineNumberInput;
        this.sourceInfoExpressions = sourceInfoExpressions;
        this.resultCollector = resultCollector;
    }

    Input<String> getSourceUriInput() {
        return this.sourceUriInput;
    }

    Input<Long> getLineNumberInput() {
        return this.lineNumberInput;
    }

    List<? extends CollectExpression<Row, ?>> getSourceInfoExpressions() {
        return this.sourceInfoExpressions;
    }

    UpsertResultCollector getResultCollector() {
        return this.resultCollector;
    }

    BiConsumer<ShardedRequests, String> getItemFailureRecorder() {
        return (s, f) -> s.addFailedItem(this.sourceUriInput.value(), (String)f, this.lineNumberInput.value());
    }

    Predicate<ShardedRequests> getHasSourceUriFailureChecker() {
        return s -> {
            String sourceUriFailure = this.sourceUriFailureInput.value();
            if (sourceUriFailure != null) {
                s.addFailedUri(this.sourceUriInput.value(), this.sourceUriFailureInput.value());
                return true;
            }
            return false;
        };
    }
}

