/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.indexing;

import com.carrotsearch.hppc.IntArrayList;
import io.crate.data.CollectionBucket;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.execution.dml.ShardResponse;
import io.crate.execution.engine.indexing.RowSourceInfo;
import io.crate.execution.engine.indexing.UpsertResultCollector;
import io.crate.execution.engine.indexing.UpsertResults;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.cluster.node.DiscoveryNode;

final class UpsertResultCollectors {
    static UpsertResultCollector newResultRowCollector() {
        return new ResultRowCollector();
    }

    static UpsertResultCollector newRowCountCollector() {
        return new RowCountCollector();
    }

    static UpsertResultCollector newSummaryCollector(DiscoveryNode localNode) {
        return new SummaryCollector(Map.of("id", localNode.getId(), "name", localNode.getName()));
    }

    private UpsertResultCollectors() {
    }

    private static class ResultRowCollector
    implements UpsertResultCollector {
        private final Object lock = new Object();

        private ResultRowCollector() {
        }

        @Override
        public Supplier<UpsertResults> supplier() {
            return UpsertResults::new;
        }

        @Override
        public UpsertResultCollector.Accumulator accumulator() {
            return this::processShardResponse;
        }

        @Override
        public BinaryOperator<UpsertResults> combiner() {
            return (i, o) -> {
                Object object = this.lock;
                synchronized (object) {
                    i.addResultRows(o.getResultRowsForNoUri());
                }
                return i;
            };
        }

        @Override
        public Function<UpsertResults, Iterable<Row>> finisher() {
            return r -> new CollectionBucket(r.getResultRowsForNoUri());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processShardResponse(UpsertResults upsertResults, ShardResponse shardResponse, List<RowSourceInfo> rowSourceInfosIgnored) {
            List<Object[]> resultRows = shardResponse.getResultRows();
            if (resultRows != null) {
                Object object = this.lock;
                synchronized (object) {
                    upsertResults.addResultRows(resultRows);
                }
            }
        }
    }

    private static class RowCountCollector
    implements UpsertResultCollector {
        private final Object lock = new Object();

        private RowCountCollector() {
        }

        @Override
        public Supplier<UpsertResults> supplier() {
            return UpsertResults::new;
        }

        @Override
        public UpsertResultCollector.Accumulator accumulator() {
            return this::processShardResponse;
        }

        @Override
        public BinaryOperator<UpsertResults> combiner() {
            return (i, o) -> {
                Object object = this.lock;
                synchronized (object) {
                    i.addResult(o.getSuccessRowCountForNoUri());
                }
                return i;
            };
        }

        @Override
        public Function<UpsertResults, Iterable<Row>> finisher() {
            return r -> Collections.singletonList(new Row1(r.getSuccessRowCountForNoUri()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processShardResponse(UpsertResults upsertResults, ShardResponse shardResponse, List<RowSourceInfo> rowSourceInfosIgnored) {
            Object object = this.lock;
            synchronized (object) {
                upsertResults.addResult(shardResponse.successRowCount());
            }
        }
    }

    private static class SummaryCollector
    implements UpsertResultCollector {
        private final Map<String, String> nodeInfo;
        private final Object lock = new Object();

        SummaryCollector(Map<String, String> nodeInfo) {
            this.nodeInfo = nodeInfo;
        }

        @Override
        public Supplier<UpsertResults> supplier() {
            return () -> new UpsertResults(this.nodeInfo);
        }

        @Override
        public UpsertResultCollector.Accumulator accumulator() {
            return this::processShardResponse;
        }

        @Override
        public BinaryOperator<UpsertResults> combiner() {
            return (i, o) -> {
                Object object = this.lock;
                synchronized (object) {
                    i.merge((UpsertResults)o);
                }
                return i;
            };
        }

        @Override
        public Function<UpsertResults, Iterable<Row>> finisher() {
            return UpsertResults::rowsIterable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processShardResponse(UpsertResults upsertResults, ShardResponse shardResponse, List<RowSourceInfo> rowSourceInfos) {
            Object object = this.lock;
            synchronized (object) {
                List<ShardResponse.Failure> failures = shardResponse.failures();
                IntArrayList locations = shardResponse.itemIndices();
                for (int i = 0; i < failures.size(); ++i) {
                    ShardResponse.Failure failure = failures.get(i);
                    int location = locations.get(i);
                    RowSourceInfo rowSourceInfo = rowSourceInfos.get(location);
                    String msg = failure == null ? null : failure.message();
                    upsertResults.addResult(rowSourceInfo.sourceUri, msg, rowSourceInfo.lineNumber);
                }
            }
        }
    }
}

