/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.indexing;

import io.crate.action.FutureActionListener;
import io.crate.action.LimitedExponentialBackoff;
import io.crate.breaker.BlockBasedRamAccounting;
import io.crate.breaker.RamAccounting;
import io.crate.breaker.TypeGuessEstimateRowSize;
import io.crate.common.unit.TimeValue;
import io.crate.data.BatchIterator;
import io.crate.data.BatchIterators;
import io.crate.data.Row;
import io.crate.execution.dml.ShardResponse;
import io.crate.execution.dml.upsert.ShardUpsertRequest;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.collect.RowShardResolver;
import io.crate.execution.engine.indexing.BatchIteratorBackpressureExecutor;
import io.crate.execution.engine.indexing.BulkShardCreationLimiter;
import io.crate.execution.engine.indexing.GroupRowsByShard;
import io.crate.execution.engine.indexing.RowSourceInfo;
import io.crate.execution.engine.indexing.ShardLocation;
import io.crate.execution.engine.indexing.ShardedRequests;
import io.crate.execution.engine.indexing.UpsertResultCollector;
import io.crate.execution.engine.indexing.UpsertResultContext;
import io.crate.execution.engine.indexing.UpsertResults;
import io.crate.execution.jobs.NodeJobsCounter;
import io.crate.execution.support.RetryListener;
import io.crate.settings.CrateSetting;
import io.crate.types.DataTypes;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreatePartitionsRequest;
import org.elasticsearch.action.admin.indices.create.TransportCreatePartitionsAction;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkRequestExecutor;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.index.shard.ShardId;

public class ShardingUpsertExecutor
implements Function<BatchIterator<Row>, CompletableFuture<? extends Iterable<? extends Row>>> {
    public static final CrateSetting<TimeValue> BULK_REQUEST_TIMEOUT_SETTING = CrateSetting.of(Setting.positiveTimeSetting("bulk.request_timeout", new TimeValue(1L, TimeUnit.MINUTES), Setting.Property.NodeScope, Setting.Property.Dynamic), DataTypes.STRING);
    private static final BackoffPolicy BACKOFF_POLICY = LimitedExponentialBackoff.limitedExponential(1000);
    private static final Logger LOGGER = LogManager.getLogger(ShardingUpsertExecutor.class);
    private static final double BREAKER_LIMIT_PERCENTAGE = 0.5;
    private final GroupRowsByShard<ShardUpsertRequest, ShardUpsertRequest.Item> grouper;
    private final NodeJobsCounter nodeJobsCounter;
    private final ScheduledExecutorService scheduler;
    private final Executor executor;
    private final int bulkSize;
    private final UUID jobId;
    private final Function<ShardId, ShardUpsertRequest> requestFactory;
    private final BulkRequestExecutor<ShardUpsertRequest> requestExecutor;
    private final TransportCreatePartitionsAction createPartitionsAction;
    private final BulkShardCreationLimiter bulkShardCreationLimiter;
    private final UpsertResultCollector resultCollector;
    private final boolean isDebugEnabled;
    private final CircuitBreaker queryCircuitBreaker;
    private final String localNode;
    private final BlockBasedRamAccounting ramAccounting;
    private volatile boolean createPartitionsRequestOngoing = false;

    ShardingUpsertExecutor(ClusterService clusterService, NodeJobsCounter nodeJobsCounter, CircuitBreaker queryCircuitBreaker, RamAccounting ramAccounting, ScheduledExecutorService scheduler, Executor executor, int bulkSize, UUID jobId, RowShardResolver rowShardResolver, Function<String, ShardUpsertRequest.Item> itemFactory, Function<ShardId, ShardUpsertRequest> requestFactory, List<? extends CollectExpression<Row, ?>> expressions, Supplier<String> indexNameResolver, boolean autoCreateIndices, BulkRequestExecutor<ShardUpsertRequest> requestExecutor, TransportCreatePartitionsAction createPartitionsAction, int targetTableNumShards, int targetTableNumReplicas, UpsertResultContext upsertResultContext) {
        this.localNode = clusterService.state().getNodes().getLocalNodeId();
        this.nodeJobsCounter = nodeJobsCounter;
        this.queryCircuitBreaker = queryCircuitBreaker;
        this.scheduler = scheduler;
        this.executor = executor;
        this.bulkSize = bulkSize;
        this.jobId = jobId;
        this.requestFactory = requestFactory;
        this.requestExecutor = requestExecutor;
        this.createPartitionsAction = createPartitionsAction;
        TypeGuessEstimateRowSize estimateRowSize = new TypeGuessEstimateRowSize();
        this.ramAccounting = new BlockBasedRamAccounting(ramAccounting::addBytes, (int)ByteSizeUnit.MB.toBytes(2L));
        this.grouper = new GroupRowsByShard(clusterService, rowShardResolver, estimateRowSize, indexNameResolver, expressions, itemFactory, autoCreateIndices, upsertResultContext);
        this.bulkShardCreationLimiter = new BulkShardCreationLimiter(targetTableNumShards, targetTableNumReplicas, clusterService.state().nodes().getDataNodes().size());
        this.resultCollector = upsertResultContext.getResultCollector();
        this.isDebugEnabled = LOGGER.isDebugEnabled();
    }

    public CompletableFuture<UpsertResults> execute(ShardedRequests<ShardUpsertRequest, ShardUpsertRequest.Item> requests) {
        UpsertResults upsertResults = this.resultCollector.supplier().get();
        ShardingUpsertExecutor.collectFailingSourceUris(requests, upsertResults);
        ShardingUpsertExecutor.collectFailingItems(requests, upsertResults);
        if (requests.itemsByMissingIndex.isEmpty()) {
            return this.execRequests(requests, upsertResults);
        }
        this.createPartitionsRequestOngoing = true;
        return this.createPartitions(requests.itemsByMissingIndex).thenCompose(resp -> {
            this.grouper.reResolveShardLocations(requests);
            this.createPartitionsRequestOngoing = false;
            return this.execRequests(requests, upsertResults);
        });
    }

    private static void collectFailingSourceUris(ShardedRequests<ShardUpsertRequest, ShardUpsertRequest.Item> requests, UpsertResults upsertResults) {
        for (Map.Entry<String, String> entry : requests.sourceUrisWithFailure.entrySet()) {
            upsertResults.addUriFailure(entry.getKey(), entry.getValue());
        }
    }

    private static void collectFailingItems(ShardedRequests<ShardUpsertRequest, ShardUpsertRequest.Item> requests, UpsertResults upsertResults) {
        for (Map.Entry<String, List<ShardedRequests.ReadFailureAndLineNumber>> entry : requests.itemsWithFailureBySourceUri.entrySet()) {
            String sourceUri = entry.getKey();
            for (ShardedRequests.ReadFailureAndLineNumber readFailureAndLineNumber : entry.getValue()) {
                upsertResults.addResult(sourceUri, readFailureAndLineNumber.readFailure, readFailureAndLineNumber.lineNumber);
            }
        }
    }

    private CompletableFuture<UpsertResults> execRequests(ShardedRequests<ShardUpsertRequest, ShardUpsertRequest.Item> requests, UpsertResults upsertResults) {
        if (requests.itemsByShard.isEmpty()) {
            requests.close();
            return CompletableFuture.completedFuture(upsertResults);
        }
        AtomicInteger numRequests = new AtomicInteger(requests.itemsByShard.size());
        AtomicReference<Object> interrupt = new AtomicReference<Object>(null);
        CompletableFuture<UpsertResults> resultFuture = new CompletableFuture<UpsertResults>();
        Iterator it = requests.itemsByShard.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ShardUpsertRequest request = (ShardUpsertRequest)entry.getValue();
            it.remove();
            String nodeId = entry.getKey().nodeId;
            this.nodeJobsCounter.increment(nodeId);
            ActionListener<ShardResponse> listener = new ShardResponseActionListener(nodeId, numRequests, interrupt, upsertResults, this.resultCollector.accumulator(), requests.rowSourceInfos, resultFuture);
            listener = new RetryListener<ShardResponse>(this.scheduler, l -> {
                if (this.isDebugEnabled) {
                    LOGGER.debug("Executing retry Listener for nodeId: {} request: {}", (Object)nodeId, (Object)request);
                }
                this.requestExecutor.execute(request, (ActionListener<ShardResponse>)l);
            }, listener, BACKOFF_POLICY);
            this.requestExecutor.execute(request, listener);
        }
        return resultFuture.whenComplete((r, err) -> requests.close());
    }

    private CompletableFuture<AcknowledgedResponse> createPartitions(Map<String, List<ShardedRequests.ItemAndRoutingAndSourceInfo<ShardUpsertRequest.Item>>> itemsByMissingIndex) {
        FutureActionListener listener = FutureActionListener.newInstance();
        this.createPartitionsAction.execute(new CreatePartitionsRequest(itemsByMissingIndex.keySet(), this.jobId), listener);
        return listener;
    }

    private boolean shouldPauseOnTargetNodeJobsCounter(ShardedRequests<ShardUpsertRequest, ShardUpsertRequest.Item> requests) {
        for (ShardLocation shardLocation : requests.itemsByShard.keySet()) {
            String requestNodeId = shardLocation.nodeId;
            if (this.nodeJobsCounter.getInProgressJobsForNode(requestNodeId) < 5L) continue;
            if (this.isDebugEnabled) {
                LOGGER.debug("reached maximum concurrent operations for node {}", (Object)requestNodeId);
            }
            return true;
        }
        return false;
    }

    private boolean shouldPauseOnPartitionCreation(ShardedRequests<ShardUpsertRequest, ShardUpsertRequest.Item> ignore) {
        if (this.createPartitionsRequestOngoing) {
            if (this.isDebugEnabled) {
                LOGGER.debug("partition creation in progress, will pause");
            }
            return true;
        }
        return false;
    }

    long computeBulkByteThreshold() {
        long minAcceptableBytes = ByteSizeUnit.KB.toBytes(64L);
        long localJobs = Math.max(1L, this.nodeJobsCounter.getInProgressJobsForNode(this.localNode));
        double memoryRatio = 1.0 / (double)localJobs;
        long wantedBytes = Math.max((long)((double)this.queryCircuitBreaker.getFree() * 0.5 * memoryRatio), minAcceptableBytes);
        return wantedBytes;
    }

    @Override
    public CompletableFuture<? extends Iterable<Row>> apply(BatchIterator<Row> batchIterator) {
        long bulkBytesThreshold;
        this.nodeJobsCounter.increment(this.localNode);
        try {
            bulkBytesThreshold = this.computeBulkByteThreshold();
        }
        catch (Throwable t) {
            this.nodeJobsCounter.decrement(this.localNode);
            return CompletableFuture.failedFuture(t);
        }
        IsUsedBytesOverThreshold isUsedBytesOverThreshold = new IsUsedBytesOverThreshold(bulkBytesThreshold);
        BatchIterator<ShardUpsertRequest> reqBatchIterator = BatchIterators.partition(batchIterator, this.bulkSize, () -> new ShardedRequests(this.requestFactory, this.ramAccounting), this.grouper, this.bulkShardCreationLimiter.or(isUsedBytesOverThreshold));
        Predicate<ShardedRequests> shouldPause = this::shouldPauseOnPartitionCreation;
        if (batchIterator.hasLazyResultSet()) {
            shouldPause = shouldPause.or(this::shouldPauseOnTargetNodeJobsCounter).or(isUsedBytesOverThreshold);
        }
        BatchIteratorBackpressureExecutor<ShardedRequests, UpsertResults> executor = new BatchIteratorBackpressureExecutor<ShardedRequests, UpsertResults>(this.jobId, this.scheduler, this.executor, reqBatchIterator, this::execute, this.resultCollector.combiner(), this.resultCollector.supplier().get(), shouldPause, BACKOFF_POLICY);
        return ((CompletableFuture)executor.consumeIteratorAndExecute().thenApply(upsertResults -> this.resultCollector.finisher().apply((UpsertResults)upsertResults))).whenComplete((res, err) -> this.nodeJobsCounter.decrement(this.localNode));
    }

    private class ShardResponseActionListener
    implements ActionListener<ShardResponse> {
        private final String operationNodeId;
        private final UpsertResultCollector.Accumulator resultAccumulator;
        private final List<RowSourceInfo> rowSourceInfos;
        private final UpsertResults upsertResults;
        private final AtomicInteger numRequests;
        private final AtomicReference<Exception> interrupt;
        private final CompletableFuture<UpsertResults> upsertResultFuture;

        ShardResponseActionListener(String operationNodeId, AtomicInteger numRequests, AtomicReference<Exception> interrupt, UpsertResults upsertResults, UpsertResultCollector.Accumulator resultAccumulator, List<RowSourceInfo> rowSourceInfos, CompletableFuture<UpsertResults> upsertResultFuture) {
            this.operationNodeId = operationNodeId;
            this.numRequests = numRequests;
            this.interrupt = interrupt;
            this.upsertResults = upsertResults;
            this.resultAccumulator = resultAccumulator;
            this.rowSourceInfos = rowSourceInfos;
            this.upsertResultFuture = upsertResultFuture;
        }

        @Override
        public void onResponse(ShardResponse shardResponse) {
            ShardingUpsertExecutor.this.nodeJobsCounter.decrement(this.operationNodeId);
            this.resultAccumulator.accept(this.upsertResults, shardResponse, this.rowSourceInfos);
            this.maybeSetInterrupt(shardResponse.failure());
            this.countdown();
        }

        @Override
        public void onFailure(Exception e) {
            ShardingUpsertExecutor.this.nodeJobsCounter.decrement(this.operationNodeId);
            this.countdown();
        }

        private void countdown() {
            if (this.numRequests.decrementAndGet() == 0) {
                Exception interruptedException = this.interrupt.get();
                if (interruptedException == null) {
                    this.upsertResultFuture.complete(this.upsertResults);
                } else {
                    this.upsertResultFuture.completeExceptionally(interruptedException);
                }
            }
        }

        private void maybeSetInterrupt(@Nullable Exception failure) {
            if (failure instanceof InterruptedException) {
                this.interrupt.set(failure);
            }
        }
    }

    private static class IsUsedBytesOverThreshold
    implements Predicate<ShardedRequests<?, ?>> {
        private final long maxBytesUsableByShardedRequests;

        IsUsedBytesOverThreshold(long maxBytesUsableByShardedRequests) {
            this.maxBytesUsableByShardedRequests = maxBytesUsableByShardedRequests;
        }

        @Override
        public final boolean test(ShardedRequests<?, ?> shardedRequests) {
            boolean requestsTooBig;
            long usedMemoryEstimate = shardedRequests.ramBytesUsed();
            boolean bl = requestsTooBig = usedMemoryEstimate > this.maxBytesUsableByShardedRequests;
            if (requestsTooBig && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating smaller bulk requests because shardedRequests is using too much memory. ramBytesUsed={} itemsByShard={} itemSize={} maxBytesUsableByShardedRequests={}", (Object)shardedRequests.ramBytesUsed(), (Object)shardedRequests.itemsByShard().size(), (Object)(shardedRequests.ramBytesUsed() / (long)Math.max(shardedRequests.itemsByShard().size(), 1)), (Object)this.maxBytesUsableByShardedRequests);
            }
            return requestsTooBig;
        }
    }
}

