/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.indexing;

import io.crate.breaker.RamAccounting;
import io.crate.data.BatchIterator;
import io.crate.data.CollectingBatchIterator;
import io.crate.data.Input;
import io.crate.data.Projector;
import io.crate.data.Row;
import io.crate.execution.dml.upsert.ShardUpsertRequest;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.collect.RowShardResolver;
import io.crate.execution.engine.indexing.ShardingUpsertExecutor;
import io.crate.execution.engine.indexing.UpsertResultContext;
import io.crate.execution.jobs.NodeJobsCounter;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.TransactionContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.indices.create.TransportCreatePartitionsAction;
import org.elasticsearch.action.bulk.BulkRequestExecutor;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;

public class IndexWriterProjector
implements Projector {
    private final ShardingUpsertExecutor shardingUpsertExecutor;

    public IndexWriterProjector(ClusterService clusterService, NodeJobsCounter nodeJobsCounter, CircuitBreaker queryCircuitBreaker, RamAccounting ramAccounting, ScheduledExecutorService scheduler, Executor executor, TransactionContext txnCtx, NodeContext nodeCtx, Settings settings, int targetTableNumShards, int targetTableNumReplicas, TransportCreatePartitionsAction transportCreatePartitionsAction, BulkRequestExecutor<ShardUpsertRequest> shardUpsertAction, Supplier<String> indexNameResolver, Reference rawSourceReference, List<ColumnIdent> primaryKeyIdents, List<? extends Symbol> primaryKeySymbols, @Nullable Symbol routingSymbol, ColumnIdent clusteredByColumn, Input<?> sourceInput, List<? extends CollectExpression<Row, ?>> collectExpressions, int bulkActions, @Nullable String[] includes, @Nullable String[] excludes, boolean autoCreateIndices, boolean overwriteDuplicates, UUID jobId, UpsertResultContext upsertResultContext) {
        MapInput source = includes == null && excludes == null ? sourceInput : new MapInput(sourceInput, includes, excludes);
        RowShardResolver rowShardResolver = new RowShardResolver(txnCtx, nodeCtx, primaryKeyIdents, primaryKeySymbols, clusteredByColumn, routingSymbol);
        ShardUpsertRequest.Builder builder = new ShardUpsertRequest.Builder(txnCtx.sessionSettings(), ShardingUpsertExecutor.BULK_REQUEST_TIMEOUT_SETTING.setting().get(settings), overwriteDuplicates ? ShardUpsertRequest.DuplicateKeyAction.OVERWRITE : ShardUpsertRequest.DuplicateKeyAction.UPDATE_OR_FAIL, true, null, new Reference[]{rawSourceReference}, null, jobId, false);
        Function<String, ShardUpsertRequest.Item> itemFactory = id -> new ShardUpsertRequest.Item((String)id, null, new Object[]{source.value()}, null, null, null);
        this.shardingUpsertExecutor = new ShardingUpsertExecutor(clusterService, nodeJobsCounter, queryCircuitBreaker, ramAccounting, scheduler, executor, bulkActions, jobId, rowShardResolver, itemFactory, builder::newRequest, collectExpressions, indexNameResolver, autoCreateIndices, shardUpsertAction, transportCreatePartitionsAction, targetTableNumShards, targetTableNumReplicas, upsertResultContext);
    }

    @Override
    public BatchIterator<Row> apply(BatchIterator<Row> batchIterator) {
        return CollectingBatchIterator.newInstance(batchIterator, this.shardingUpsertExecutor, batchIterator.hasLazyResultSet());
    }

    @Override
    public boolean providesIndependentScroll() {
        return false;
    }

    private static class MapInput
    implements Input<String> {
        private final Input<Map<String, Object>> sourceInput;
        private final String[] includes;
        private final String[] excludes;
        private static final Logger LOGGER = LogManager.getLogger(MapInput.class);
        private int lastSourceSize;

        private MapInput(Input<Map<String, Object>> sourceInput, String[] includes, String[] excludes) {
            this.sourceInput = sourceInput;
            this.includes = includes;
            this.excludes = excludes;
            this.lastSourceSize = 16384;
        }

        @Override
        public String value() {
            Map<String, Object> value = this.sourceInput.value();
            if (value == null) {
                return null;
            }
            Map<String, Object> filteredMap = XContentMapValues.filter(value, this.includes, this.excludes);
            try {
                BytesReference bytes = BytesReference.bytes(new XContentBuilder(XContentType.JSON.xContent(), new BytesStreamOutput(this.lastSourceSize)).map(filteredMap));
                this.lastSourceSize = bytes.length();
                return bytes.utf8ToString();
            }
            catch (IOException ex) {
                LOGGER.error("could not parse xContent", (Throwable)ex);
                return null;
            }
        }
    }
}

